#include "mbed.h"

// i2c addresses
int C39_adr = 0x27 << 1;
int pcal_adr = 0x20 << 1;

// initialise global variables
char C39_data[3] = {0, 255, 255};
char pcal_data[1] = {0};
int instWeight = 0;
char testArray[3] = {1, 2, 3};
char rxArray[3] = {0, 0, 0};

//Set up serial and I2C connections
Serial pc(USBTX, USBRX);
UARTSerial s1(p13, p14);
UARTSerial s2(p28, p27);
I2C c39(p9, p10);
I2C pcal(p9, p10);

int c39Read(int address, char* array, int array_length) {
    
    c39.read(address, array, array_length);
    
    
    if (array[1] < 255) {
        instWeight = array[1] << 8;
        instWeight = instWeight | array[2];
        //pc.printf("%d\n",instWeight);
    }
    return 0;      
}

int pcalRead(int address, char* array, int array_length) {
    
    int pcalAck = 1;
    
    pcalAck = pcal.read(address, array, array_length);

    if (pcalAck == 0) {
        pc.printf("ACK\n");
    }
    
    pc.printf("%d\n",array[0]);
    
    return 0;      
}

const event_callback_t callback(){
    
    pc.printf("Complete");
    
    return 0;
    }
    

//int serialWrite(char* array, int array_length, const event_callback_t callback, int event) {
//    
//    s1.write(array, array_length, callback, event);
//    
//    }

int main() {
    
    s2.set_blocking(0);
    
    while(1){
        //c39Read(C39_adr, C39_data, 3);
        //pc.printf("%d\n",instWeight);
        //pcalRead(pcal_adr, pcal_data, 1);
        s2.write(testArray, 3);
        s2.read(rxArray, 3);
        pc.printf("%d\n", rxArray[0]);
        wait(0.5);
        //pc.printf("%d\n",pcal_data[0]);
    }
}


