#include "mbed.h"
#include "Chirp.h"

//Chirp Docs are at https://github.com/Miceuz/i2c-moisture-sensor and https://www.tindie.com/products/miceuz/i2c-soil-moisture-sensor/

Chirp::Chirp(PinName sda, PinName scl, char slave_adr)
    :i2c_p(new I2C(sda, scl)), i2c(*i2c_p), address(slave_adr)
{
    i2c.frequency(10000);
}

float Chirp::getCapacitance(){
    i2c.frequency(10000);
    short capacitance = 0;
    char i2cData[2]= {0}; 
    
    char dataReg = 0; //Capacitance is stored in 2 bytes at address 0
    i2c.write(address, &dataReg, 1); 
    int success = i2c.read(address, i2cData, 2);
    
    if(success != 0)
        return -1000000; 
    else
    {
        //I2C bytes are in different byte order, write into short bytes 0 and 1 in reverse order!
        *((char*)&capacitance) = i2cData[1];
        *(((char*)(&capacitance)) + 1) = i2cData[0];
        return capacitance;
    }
}

float Chirp::getTemperature(){
    i2c.frequency(10000);
    short temperature = 0;
    char i2cData[2]= {0}; 
    
    
    char dataReg = 5; //Temperature is stored in 2 bytes at address 5
    i2c.write(address, &dataReg, 1); 
    int success = i2c.read(address, i2cData, 2);
    
    if(success != 0)
        return -1000000; 
    else
    {
        *((char*)&temperature) = i2cData[1];
        *(((char*)(&temperature)) + 1) = i2cData[0];
        return (float) temperature / 10.0;
    }
}
    