/* ================================================================================
 
     Created by   : 
     Created on   : 2019 Oct 08, 09:43 GMT Daylight Time

     Project      :   ADMW1001_REGISTERS
     File         :   ADMW1001_REGISTERS.h
     Description  :   Register Definitions

     !! ADI Confidential !!
       INTERNAL USE ONLY

     Copyright (c) 2019 Analog Devices, Inc.  All Rights Reserved.
     This software is proprietary and confidential to Analog Devices, Inc. and
     its licensors.

     This file was auto-generated. Do not make local changes to this file.
 
     Auto generation script information:
       Script:        C:\Program Files (x86)\Yoda-19.05.01\generators\inc\genHeaders
       Last modified: 26-SEP-2017

   ================================================================================ */

#ifndef _DEF_ADMW1001_REGISTERS_H
#define _DEF_ADMW1001_REGISTERS_H

#if defined(_LANGUAGE_C) || (defined(__GNUC__) && !defined(__ASSEMBLER__))
#include <stdint.h>
#endif /* _LANGUAGE_C */

#ifndef __ADI_GENERATED_DEF_HEADERS__
#define __ADI_GENERATED_DEF_HEADERS__    1
#endif

#define __ADI_HAS_CORE__           1
#define __ADI_HAS_SPI__            1
#define __ADI_HAS_ADMW_TEST__      1

/* ============================================================================================================================
        
   ============================================================================================================================ */

/* ============================================================================================================================
        SPI
   ============================================================================================================================ */
#define MOD_SPI_BASE                         0x00000000            /*    */
#define MOD_SPI_MASK                         0x00007FFF            /*    */
#define REG_SPI_INTERFACE_CONFIG_A_RESET     0x00000030            /*      Reset Value for Interface_Config_A  */
#define REG_SPI_INTERFACE_CONFIG_A           0x00000000            /*  SPI Interface Configuration A */
#define REG_SPI_INTERFACE_CONFIG_B_RESET     0x00000000            /*      Reset Value for Interface_Config_B  */
#define REG_SPI_INTERFACE_CONFIG_B           0x00000001            /*  SPI Interface Configuration B */
#define REG_SPI_CHIP_TYPE_RESET              0x00000007            /*      Reset Value for Chip_Type  */
#define REG_SPI_CHIP_TYPE                    0x00000003            /*  SPI Chip Type */
#define REG_SPI_PRODUCT_ID_L_RESET           0x00000020            /*      Reset Value for Product_ID_L  */
#define REG_SPI_PRODUCT_ID_L                 0x00000004            /*  SPI Product ID Low */
#define REG_SPI_PRODUCT_ID_H_RESET           0x00000000            /*      Reset Value for Product_ID_H  */
#define REG_SPI_PRODUCT_ID_H                 0x00000005            /*  SPI Product ID High */
#define REG_SPI_CHIP_GRADE_RESET             0x00000000            /*      Reset Value for Chip_Grade  */
#define REG_SPI_CHIP_GRADE                   0x00000006            /*  SPI Chip Grade */
#define REG_SPI_SCRATCH_PAD_RESET            0x00000000            /*      Reset Value for Scratch_Pad  */
#define REG_SPI_SCRATCH_PAD                  0x0000000A            /*  SPI Scratch Pad */
#define REG_SPI_SPI_REVISION_RESET           0x00000082            /*      Reset Value for SPI_Revision  */
#define REG_SPI_SPI_REVISION                 0x0000000B            /*  SPI SPI Revision */
#define REG_SPI_VENDOR_L_RESET               0x00000056            /*      Reset Value for Vendor_L  */
#define REG_SPI_VENDOR_L                     0x0000000C            /*  SPI Vendor ID Low */
#define REG_SPI_VENDOR_H_RESET               0x00000004            /*      Reset Value for Vendor_H  */
#define REG_SPI_VENDOR_H                     0x0000000D            /*  SPI Vendor ID High */
#define REG_SPI_STREAM_MODE_RESET            0x00000000            /*      Reset Value for Stream_Mode  */
#define REG_SPI_STREAM_MODE                  0x0000000E            /*  SPI Stream Mode */
#define REG_SPI_TRANSFER_CONFIG_RESET        0x00000000            /*      Reset Value for Transfer_Config  */
#define REG_SPI_TRANSFER_CONFIG              0x0000000F            /*  SPI Transfer Config */
#define REG_SPI_INTERFACE_CONFIG_C_RESET     0x00000033            /*      Reset Value for Interface_Config_C  */
#define REG_SPI_INTERFACE_CONFIG_C           0x00000010            /*  SPI Interface Configuration C */
#define REG_SPI_INTERFACE_STATUS_A_RESET     0x00000000            /*      Reset Value for Interface_Status_A  */
#define REG_SPI_INTERFACE_STATUS_A           0x00000011            /*  SPI Interface Status A */

/* ============================================================================================================================
        SPI Register BitMasks, Positions & Enumerations 
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_CONFIG_A               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_CONFIG_A_SW_RESET  7            /*  First of Two of the SW_RESET Bits. */
#define BITP_SPI_INTERFACE_CONFIG_A_ADDR_ASCENSION  5            /*  Determines Sequential Addressing Behavior */
#define BITP_SPI_INTERFACE_CONFIG_A_SDO_ENABLE  4            /*  Serial Data Output Pin Enable */
#define BITP_SPI_INTERFACE_CONFIG_A_SW_RESETX  0            /*  Second  of Two of  the SW_RESET Bits. */
#define BITM_SPI_INTERFACE_CONFIG_A_SW_RESET 0x00000080    /*  First of Two of the SW_RESET Bits. */
#define BITM_SPI_INTERFACE_CONFIG_A_ADDR_ASCENSION 0x00000020    /*  Determines Sequential Addressing Behavior */
#define BITM_SPI_INTERFACE_CONFIG_A_SDO_ENABLE 0x00000010    /*  Serial Data Output Pin Enable */
#define BITM_SPI_INTERFACE_CONFIG_A_SW_RESETX 0x00000001    /*  Second  of Two of  the SW_RESET Bits. */
#define ENUM_SPI_INTERFACE_CONFIG_A_DESCEND  0x00000000            /*  Addr_Ascension: Address accessed is decremented by one for each data byte when streaming */
#define ENUM_SPI_INTERFACE_CONFIG_A_ASCEND   0x00000020            /*  Addr_Ascension: Address accessed is incremented by one for each data byte when streaming */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_CONFIG_B               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_CONFIG_B_SINGLE_INST  7            /*  Select Streaming or Single Instruction Mode */
#define BITM_SPI_INTERFACE_CONFIG_B_SINGLE_INST 0x00000080    /*  Select Streaming or Single Instruction Mode */
#define ENUM_SPI_INTERFACE_CONFIG_B_STREAMING_MODE 0x00000000            /*  Single_Inst: Streaming mode is enabled */
#define ENUM_SPI_INTERFACE_CONFIG_B_SINGLE_INSTRUCTION_MODE 0x00000080            /*  Single_Inst: Single Instruction mode is enabled */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_CHIP_TYPE                        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_CHIP_TYPE_CHIP_TYPE          0            /*  Precision ADC */
#define BITM_SPI_CHIP_TYPE_CHIP_TYPE         0x0000000F    /*  Precision ADC */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_PRODUCT_ID_L                     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_PRODUCT_ID_L_PRODUCT_ID_FIXED_BITS  4            /*  These Bits are Fixed on Die Configured for Multiple Generics */
#define BITP_SPI_PRODUCT_ID_L_PRODUCT_ID_TRIM_BITS  0            /*  These Bits Vary on Die Configured for Multiple Generics */
#define BITM_SPI_PRODUCT_ID_L_PRODUCT_ID_FIXED_BITS 0x000000F0    /*  These Bits are Fixed on Die Configured for Multiple Generics */
#define BITM_SPI_PRODUCT_ID_L_PRODUCT_ID_TRIM_BITS 0x0000000F    /*  These Bits Vary on Die Configured for Multiple Generics */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_PRODUCT_ID_H                     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_PRODUCT_ID_H_PRODUCT_ID_FIXED_BITS  0            /*  These Bits are Fixed on Die Configured for Multiple Generics */
#define BITM_SPI_PRODUCT_ID_H_PRODUCT_ID_FIXED_BITS 0x000000FF    /*  These Bits are Fixed on Die Configured for Multiple Generics */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_CHIP_GRADE                       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_CHIP_GRADE_GRADE             4            /*  Device Performance Grade */
#define BITP_SPI_CHIP_GRADE_DEVICE_REVISION   0            /*  Device Hardware Revision */
#define BITM_SPI_CHIP_GRADE_GRADE            0x000000F0    /*  Device Performance Grade */
#define BITM_SPI_CHIP_GRADE_DEVICE_REVISION  0x0000000F    /*  Device Hardware Revision */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_SCRATCH_PAD                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_SCRATCH_PAD_SCRATCH_VALUE    0            /*  Software Scratchpad */
#define BITM_SPI_SCRATCH_PAD_SCRATCH_VALUE   0x000000FF    /*  Software Scratchpad */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_SPI_REVISION                     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_SPI_REVISION_SPI_TYPE        6            /*  Always Reads as 0x2 */
#define BITP_SPI_SPI_REVISION_VERSION         0            /*  SPI Version */
#define BITM_SPI_SPI_REVISION_SPI_TYPE       0x000000C0    /*  Always Reads as 0x2 */
#define BITM_SPI_SPI_REVISION_VERSION        0x0000003F    /*  SPI Version */
#define ENUM_SPI_SPI_REVISION_ADI_SPI        0x00000000            /*  SPI_Type: ADI_SPI */
#define ENUM_SPI_SPI_REVISION_LPT_SPI        0x00000080            /*  SPI_Type: LPT_SPI */
#define ENUM_SPI_SPI_REVISION_REV1_0         0x00000002            /*  Version: Revision 1.0 */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_VENDOR_L                         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_VENDOR_L_VID                 0            /*  Analog Devices Vendor ID */
#define BITM_SPI_VENDOR_L_VID                0x000000FF    /*  Analog Devices Vendor ID */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_VENDOR_H                         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_VENDOR_H_VID                 0            /*  Analog Devices Vendor ID */
#define BITM_SPI_VENDOR_H_VID                0x000000FF    /*  Analog Devices Vendor ID */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_STREAM_MODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_STREAM_MODE_LOOP_COUNT       0            /*  Set the Data Byte Count Before Looping to Start Address */
#define BITM_SPI_STREAM_MODE_LOOP_COUNT      0x000000FF    /*  Set the Data Byte Count Before Looping to Start Address */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_TRANSFER_CONFIG                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_TRANSFER_CONFIG_STREAM_MODE  1            /*  When Streaming, Control Master to Slave Transfer */
#define BITM_SPI_TRANSFER_CONFIG_STREAM_MODE 0x00000002    /*  When Streaming, Control Master to Slave Transfer */
#define ENUM_SPI_TRANSFER_CONFIG_UPDATE_ON_WRITE 0x00000000            /*  Stream_Mode: Transfers after each byte/mulit-byte register */
#define ENUM_SPI_TRANSFER_CONFIG_UPDATE_ON_ADDRESS_LOOP 0x00000002            /*  Stream_Mode: Transfers when address loops */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_CONFIG_C               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_CONFIG_C_CRC_ENABLE  6            /*  CRC Enable */
#define BITP_SPI_INTERFACE_CONFIG_C_STRICT_REGISTER_ACCESS  5            /*  Multibyte Registers Must Be Read or Written in Full */
#define BITP_SPI_INTERFACE_CONFIG_C_SEND_STATUS  4            /*  Sends Status in 4-Wire Mode When Enabled */
#define BITP_SPI_INTERFACE_CONFIG_C_CRC_ENABLEB  0            /*  Inverted CRC Enable */
#define BITM_SPI_INTERFACE_CONFIG_C_CRC_ENABLE 0x000000C0    /*  CRC Enable */
#define BITM_SPI_INTERFACE_CONFIG_C_STRICT_REGISTER_ACCESS 0x00000020    /*  Multibyte Registers Must Be Read or Written in Full */
#define BITM_SPI_INTERFACE_CONFIG_C_SEND_STATUS 0x00000010    /*  Sends Status in 4-Wire Mode When Enabled */
#define BITM_SPI_INTERFACE_CONFIG_C_CRC_ENABLEB 0x00000003    /*  Inverted CRC Enable */
#define ENUM_SPI_INTERFACE_CONFIG_C_DISABLED 0x00000000            /*  CRC_Enable: CRC Disabled */
#define ENUM_SPI_INTERFACE_CONFIG_C_ENABLED  0x00000040            /*  CRC_Enable: CRC Enabled */
#define ENUM_SPI_INTERFACE_CONFIG_C_NORMAL_ACCESS 0x00000000            /*  Strict_Register_Access: Normal mode, no access restrictions */
#define ENUM_SPI_INTERFACE_CONFIG_C_STRICT_ACCESS 0x00000020            /*  Strict_Register_Access: Strict mode, multi-byte registers require all bytes read/written */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_STATUS_A               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_STATUS_A_NOT_READY_ERROR  7            /*  Device Not Ready for Transaction */
#define BITP_SPI_INTERFACE_STATUS_A_CLOCK_COUNT_ERROR  4            /*  Incorrect Number of Clocks Detected in a Transaction */
#define BITP_SPI_INTERFACE_STATUS_A_CRC_ERROR  3            /*  Invalid/No CRC Received */
#define BITP_SPI_INTERFACE_STATUS_A_WR_TO_RD_ONLY_REG_ERROR  2            /*  Write to Read Only Register Attempted */
#define BITP_SPI_INTERFACE_STATUS_A_REGISTER_PARTIAL_ACCESS_ERROR  1            /*  Set When Fewer Than Expected Number of Bytes Read/Written */
#define BITP_SPI_INTERFACE_STATUS_A_ADDRESS_INVALID_ERROR  0            /*  Attempt to Read/Write Nonexistent Register Address */
#define BITM_SPI_INTERFACE_STATUS_A_NOT_READY_ERROR 0x00000080    /*  Device Not Ready for Transaction */
#define BITM_SPI_INTERFACE_STATUS_A_CLOCK_COUNT_ERROR 0x00000010    /*  Incorrect Number of Clocks Detected in a Transaction */
#define BITM_SPI_INTERFACE_STATUS_A_CRC_ERROR 0x00000008    /*  Invalid/No CRC Received */
#define BITM_SPI_INTERFACE_STATUS_A_WR_TO_RD_ONLY_REG_ERROR 0x00000004    /*  Write to Read Only Register Attempted */
#define BITM_SPI_INTERFACE_STATUS_A_REGISTER_PARTIAL_ACCESS_ERROR 0x00000002    /*  Set When Fewer Than Expected Number of Bytes Read/Written */
#define BITM_SPI_INTERFACE_STATUS_A_ADDRESS_INVALID_ERROR 0x00000001    /*  Attempt to Read/Write Nonexistent Register Address */


/* ============================================================================================================================
        ADISENSE1000 Core Registers
   ============================================================================================================================ */

/* ============================================================================================================================
        CORE
   ============================================================================================================================ */
#define MOD_CORE_BASE                        0x00000010            /*  ADISENSE1000 Core Registers  */
#define MOD_CORE_MASK                        0x00007FFF            /*  ADISENSE1000 Core Registers  */
#define REG_CORE_COMMAND_RESET               0x00000000            /*      Reset Value for Command  */
#define REG_CORE_COMMAND                     0x00000014            /*  CORE Special Command Register */
#define REG_CORE_MODE_RESET                  0x00000000            /*      Reset Value for Mode  */
#define REG_CORE_MODE                        0x00000016            /*  CORE Operating Mode and DRDY Control */
#define REG_CORE_POWER_CONFIG_RESET          0x00000000            /*      Reset Value for Power_Config  */
#define REG_CORE_POWER_CONFIG                0x00000017            /*  CORE Power Configuration */
#define REG_CORE_CYCLE_CONTROL_RESET         0x00000000            /*      Reset Value for Cycle_Control  */
#define REG_CORE_CYCLE_CONTROL               0x00000018            /*  CORE Measurement Cycle */
#define REG_CORE_FIFO_NUM_CYCLES_RESET       0x00000001            /*      Reset Value for Fifo_Num_Cycles  */
#define REG_CORE_FIFO_NUM_CYCLES             0x0000001A            /*  CORE Number of Measurement Cycles to Store in FIFO */
#define REG_CORE_STATUS_RESET                0x00000000            /*      Reset Value for Status  */
#define REG_CORE_STATUS                      0x00000020            /*  CORE General Status */
#define REG_CORE_CHANNEL_ALERT_STATUS_RESET  0x00000000            /*      Reset Value for Channel_Alert_Status  */
#define REG_CORE_CHANNEL_ALERT_STATUS        0x00000026            /*  CORE Alert Status Summary */
#define REG_CORE_ALERT_DETAIL_CHn_RESET      0x00000000            /*      Reset Value for Alert_Detail_Ch[n]  */
#define REG_CORE_ALERT_DETAIL_CH0_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH0  */
#define REG_CORE_ALERT_DETAIL_CH1_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH1  */
#define REG_CORE_ALERT_DETAIL_CH2_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH2  */
#define REG_CORE_ALERT_DETAIL_CH3_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH3  */
#define REG_CORE_ALERT_DETAIL_CH4_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH4  */
#define REG_CORE_ALERT_DETAIL_CH5_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH5  */
#define REG_CORE_ALERT_DETAIL_CH6_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH6  */
#define REG_CORE_ALERT_DETAIL_CH7_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH7  */
#define REG_CORE_ALERT_DETAIL_CH8_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH8  */
#define REG_CORE_ALERT_DETAIL_CH9_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH9  */
#define REG_CORE_ALERT_DETAIL_CH10_RESET     0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH10  */
#define REG_CORE_ALERT_DETAIL_CH11_RESET     0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH11  */
#define REG_CORE_ALERT_DETAIL_CH12_RESET     0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH12  */
#define REG_CORE_ALERT_DETAIL_CH0            0x0000002A            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH1            0x0000002C            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH2            0x0000002E            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH3            0x00000030            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH4            0x00000032            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH5            0x00000034            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH6            0x00000036            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH7            0x00000038            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH8            0x0000003A            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH9            0x0000003C            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH10           0x0000003E            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH11           0x00000040            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CH12           0x00000042            /*  CORE Detailed Channel Error Information */
#define REG_CORE_ALERT_DETAIL_CHn(i)         (REG_CORE_ALERT_DETAIL_CH0 + ((i) * 2))
#define REG_CORE_ALERT_DETAIL_CHn_COUNT      13
#define REG_CORE_ERROR_CODE_RESET            0x00000000            /*      Reset Value for Error_Code  */
#define REG_CORE_ERROR_CODE                  0x0000004C            /*  CORE Code Indicating Source of Error */
#define REG_CORE_EXTERNAL_REFERENCE_RESISTOR_RESET 0x447A0000            /*      Reset Value for External_Reference_Resistor  */
#define REG_CORE_EXTERNAL_REFERENCE_RESISTOR 0x00000050            /*  CORE External Reference Resistor Value */
#define REG_CORE_DIAGNOSTICS_CONTROL_RESET   0x00000000            /*      Reset Value for Diagnostics_Control  */
#define REG_CORE_DIAGNOSTICS_CONTROL         0x0000005C            /*  CORE Diagnostic Control */
#define REG_CORE_DATA_FIFO_RESET             0x00000000            /*      Reset Value for Data_FIFO  */
#define REG_CORE_DATA_FIFO                   0x00000060            /*  CORE FIFO Buffer of Sensor Results */
#define REG_CORE_DEBUG_CODE_RESET            0x00000000            /*      Reset Value for Debug_Code  */
#define REG_CORE_DEBUG_CODE                  0x00000064            /*  CORE Additional Information on Source of Alert or Errors */
#define REG_CORE_TEST_REG_ACCESS_RESET       0x00000000            /*      Reset Value for Test_Reg_Access  */
#define REG_CORE_TEST_REG_ACCESS             0x0000006C            /*  CORE Allows Access to Test (Hidden) Registers and Features */
#define REG_CORE_LUT_SELECT_RESET            0x00000000            /*      Reset Value for LUT_Select  */
#define REG_CORE_LUT_SELECT                  0x00000070            /*  CORE LUT Read/Write Strobe */
#define REG_CORE_LUT_OFFSET_RESET            0x00000000            /*      Reset Value for LUT_Offset  */
#define REG_CORE_LUT_OFFSET                  0x00000072            /*  CORE Offset into Selected LUT */
#define REG_CORE_LUT_DATA_RESET              0x00000000            /*      Reset Value for LUT_Data  */
#define REG_CORE_LUT_DATA                    0x00000074            /*  CORE Data to Read/Write from Addressed LUT Entry */
#define REG_CORE_REVISION_RESET              0x01000000            /*      Reset Value for Revision  */
#define REG_CORE_REVISION                    0x0000008C            /*  CORE Hardware, Firmware Revision */
#define REG_CORE_CHANNEL_COUNTn_RESET        0x00000000            /*      Reset Value for Channel_Count[n]  */
#define REG_CORE_CHANNEL_COUNT0_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT0  */
#define REG_CORE_CHANNEL_COUNT1_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT1  */
#define REG_CORE_CHANNEL_COUNT2_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT2  */
#define REG_CORE_CHANNEL_COUNT3_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT3  */
#define REG_CORE_CHANNEL_COUNT4_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT4  */
#define REG_CORE_CHANNEL_COUNT5_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT5  */
#define REG_CORE_CHANNEL_COUNT6_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT6  */
#define REG_CORE_CHANNEL_COUNT7_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT7  */
#define REG_CORE_CHANNEL_COUNT8_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT8  */
#define REG_CORE_CHANNEL_COUNT9_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT9  */
#define REG_CORE_CHANNEL_COUNT10_RESET       0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT10  */
#define REG_CORE_CHANNEL_COUNT11_RESET       0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT11  */
#define REG_CORE_CHANNEL_COUNT12_RESET       0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT12  */
#define REG_CORE_CHANNEL_COUNT0              0x00000090            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT1              0x000000D0            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT2              0x00000110            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT3              0x00000150            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT4              0x00000190            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT5              0x000001D0            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT6              0x00000210            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT7              0x00000250            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT8              0x00000290            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT9              0x000002D0            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT10             0x00000310            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT11             0x00000350            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT12             0x00000390            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNTn(i)           (REG_CORE_CHANNEL_COUNT0 + ((i) * 64))
#define REG_CORE_CHANNEL_COUNTn_COUNT        13
#define REG_CORE_CHANNEL_OPTIONSn_RESET      0x00000000            /*      Reset Value for Channel_Options[n]  */
#define REG_CORE_CHANNEL_OPTIONS0_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS0  */
#define REG_CORE_CHANNEL_OPTIONS1_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS1  */
#define REG_CORE_CHANNEL_OPTIONS2_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS2  */
#define REG_CORE_CHANNEL_OPTIONS3_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS3  */
#define REG_CORE_CHANNEL_OPTIONS4_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS4  */
#define REG_CORE_CHANNEL_OPTIONS5_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS5  */
#define REG_CORE_CHANNEL_OPTIONS6_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS6  */
#define REG_CORE_CHANNEL_OPTIONS7_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS7  */
#define REG_CORE_CHANNEL_OPTIONS8_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS8  */
#define REG_CORE_CHANNEL_OPTIONS9_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS9  */
#define REG_CORE_CHANNEL_OPTIONS10_RESET     0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS10  */
#define REG_CORE_CHANNEL_OPTIONS11_RESET     0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS11  */
#define REG_CORE_CHANNEL_OPTIONS12_RESET     0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS12  */
#define REG_CORE_CHANNEL_OPTIONS0            0x00000091            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS1            0x000000D1            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS2            0x00000111            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS3            0x00000151            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS4            0x00000191            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS5            0x000001D1            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS6            0x00000211            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS7            0x00000251            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS8            0x00000291            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS9            0x000002D1            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS10           0x00000311            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS11           0x00000351            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONS12           0x00000391            /*  CORE Position of Channel Within Sequence */
#define REG_CORE_CHANNEL_OPTIONSn(i)         (REG_CORE_CHANNEL_OPTIONS0 + ((i) * 64))
#define REG_CORE_CHANNEL_OPTIONSn_COUNT      13
#define REG_CORE_SENSOR_TYPEn_RESET          0x00000000            /*      Reset Value for Sensor_Type[n]  */
#define REG_CORE_SENSOR_TYPE0_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE0  */
#define REG_CORE_SENSOR_TYPE1_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE1  */
#define REG_CORE_SENSOR_TYPE2_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE2  */
#define REG_CORE_SENSOR_TYPE3_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE3  */
#define REG_CORE_SENSOR_TYPE4_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE4  */
#define REG_CORE_SENSOR_TYPE5_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE5  */
#define REG_CORE_SENSOR_TYPE6_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE6  */
#define REG_CORE_SENSOR_TYPE7_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE7  */
#define REG_CORE_SENSOR_TYPE8_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE8  */
#define REG_CORE_SENSOR_TYPE9_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE9  */
#define REG_CORE_SENSOR_TYPE10_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE10  */
#define REG_CORE_SENSOR_TYPE11_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE11  */
#define REG_CORE_SENSOR_TYPE12_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE12  */
#define REG_CORE_SENSOR_TYPE0                0x00000092            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE1                0x000000D2            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE2                0x00000112            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE3                0x00000152            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE4                0x00000192            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE5                0x000001D2            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE6                0x00000212            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE7                0x00000252            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE8                0x00000292            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE9                0x000002D2            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE10               0x00000312            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE11               0x00000352            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE12               0x00000392            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPEn(i)             (REG_CORE_SENSOR_TYPE0 + ((i) * 64))
#define REG_CORE_SENSOR_TYPEn_COUNT          13
#define REG_CORE_SENSOR_DETAILSn_RESET       0x000000F0            /*      Reset Value for Sensor_Details[n]  */
#define REG_CORE_SENSOR_DETAILS0_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS0  */
#define REG_CORE_SENSOR_DETAILS1_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS1  */
#define REG_CORE_SENSOR_DETAILS2_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS2  */
#define REG_CORE_SENSOR_DETAILS3_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS3  */
#define REG_CORE_SENSOR_DETAILS4_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS4  */
#define REG_CORE_SENSOR_DETAILS5_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS5  */
#define REG_CORE_SENSOR_DETAILS6_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS6  */
#define REG_CORE_SENSOR_DETAILS7_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS7  */
#define REG_CORE_SENSOR_DETAILS8_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS8  */
#define REG_CORE_SENSOR_DETAILS9_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS9  */
#define REG_CORE_SENSOR_DETAILS10_RESET      0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS10  */
#define REG_CORE_SENSOR_DETAILS11_RESET      0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS11  */
#define REG_CORE_SENSOR_DETAILS12_RESET      0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS12  */
#define REG_CORE_SENSOR_DETAILS0             0x00000094            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS1             0x000000D4            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS2             0x00000114            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS3             0x00000154            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS4             0x00000194            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS5             0x000001D4            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS6             0x00000214            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS7             0x00000254            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS8             0x00000294            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS9             0x000002D4            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS10            0x00000314            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS11            0x00000354            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS12            0x00000394            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILSn(i)          (REG_CORE_SENSOR_DETAILS0 + ((i) * 64))
#define REG_CORE_SENSOR_DETAILSn_COUNT       13
#define REG_CORE_CHANNEL_EXCITATIONn_RESET   0x00000000            /*      Reset Value for Channel_Excitation[n]  */
#define REG_CORE_CHANNEL_EXCITATION0_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION0  */
#define REG_CORE_CHANNEL_EXCITATION1_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION1  */
#define REG_CORE_CHANNEL_EXCITATION2_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION2  */
#define REG_CORE_CHANNEL_EXCITATION3_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION3  */
#define REG_CORE_CHANNEL_EXCITATION4_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION4  */
#define REG_CORE_CHANNEL_EXCITATION5_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION5  */
#define REG_CORE_CHANNEL_EXCITATION6_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION6  */
#define REG_CORE_CHANNEL_EXCITATION7_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION7  */
#define REG_CORE_CHANNEL_EXCITATION8_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION8  */
#define REG_CORE_CHANNEL_EXCITATION9_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION9  */
#define REG_CORE_CHANNEL_EXCITATION10_RESET  0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION10  */
#define REG_CORE_CHANNEL_EXCITATION11_RESET  0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION11  */
#define REG_CORE_CHANNEL_EXCITATION12_RESET  0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION12  */
#define REG_CORE_CHANNEL_EXCITATION0         0x00000098            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION1         0x000000D8            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION2         0x00000118            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION3         0x00000158            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION4         0x00000198            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION5         0x000001D8            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION6         0x00000218            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION7         0x00000258            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION8         0x00000298            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION9         0x000002D8            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION10        0x00000318            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION11        0x00000358            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION12        0x00000398            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATIONn(i)      (REG_CORE_CHANNEL_EXCITATION0 + ((i) * 64))
#define REG_CORE_CHANNEL_EXCITATIONn_COUNT   13
#define REG_CORE_SETTLING_TIMEn_RESET        0x00000000            /*      Reset Value for Settling_Time[n]  */
#define REG_CORE_SETTLING_TIME0_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME0  */
#define REG_CORE_SETTLING_TIME1_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME1  */
#define REG_CORE_SETTLING_TIME2_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME2  */
#define REG_CORE_SETTLING_TIME3_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME3  */
#define REG_CORE_SETTLING_TIME4_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME4  */
#define REG_CORE_SETTLING_TIME5_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME5  */
#define REG_CORE_SETTLING_TIME6_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME6  */
#define REG_CORE_SETTLING_TIME7_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME7  */
#define REG_CORE_SETTLING_TIME8_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME8  */
#define REG_CORE_SETTLING_TIME9_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME9  */
#define REG_CORE_SETTLING_TIME10_RESET       0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME10  */
#define REG_CORE_SETTLING_TIME11_RESET       0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME11  */
#define REG_CORE_SETTLING_TIME12_RESET       0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME12  */
#define REG_CORE_SETTLING_TIME0              0x0000009A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME1              0x000000DA            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME2              0x0000011A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME3              0x0000015A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME4              0x0000019A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME5              0x000001DA            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME6              0x0000021A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME7              0x0000025A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME8              0x0000029A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME9              0x000002DA            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME10             0x0000031A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME11             0x0000035A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME12             0x0000039A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIMEn(i)           (REG_CORE_SETTLING_TIME0 + ((i) * 64))
#define REG_CORE_SETTLING_TIMEn_COUNT        13
#define REG_CORE_MEASUREMENT_SETUPn_RESET    0x00000000            /*      Reset Value for Measurement_Setup[n]  */
#define REG_CORE_MEASUREMENT_SETUP0_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP0  */
#define REG_CORE_MEASUREMENT_SETUP1_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP1  */
#define REG_CORE_MEASUREMENT_SETUP2_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP2  */
#define REG_CORE_MEASUREMENT_SETUP3_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP3  */
#define REG_CORE_MEASUREMENT_SETUP4_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP4  */
#define REG_CORE_MEASUREMENT_SETUP5_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP5  */
#define REG_CORE_MEASUREMENT_SETUP6_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP6  */
#define REG_CORE_MEASUREMENT_SETUP7_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP7  */
#define REG_CORE_MEASUREMENT_SETUP8_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP8  */
#define REG_CORE_MEASUREMENT_SETUP9_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP9  */
#define REG_CORE_MEASUREMENT_SETUP10_RESET   0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP10  */
#define REG_CORE_MEASUREMENT_SETUP11_RESET   0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP11  */
#define REG_CORE_MEASUREMENT_SETUP12_RESET   0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP12  */
#define REG_CORE_MEASUREMENT_SETUP0          0x0000009C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP1          0x000000DC            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP2          0x0000011C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP3          0x0000015C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP4          0x0000019C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP5          0x000001DC            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP6          0x0000021C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP7          0x0000025C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP8          0x0000029C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP9          0x000002DC            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP10         0x0000031C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP11         0x0000035C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUP12         0x0000039C            /*  CORE ADC Measurement Setup */
#define REG_CORE_MEASUREMENT_SETUPn(i)       (REG_CORE_MEASUREMENT_SETUP0 + ((i) * 64))
#define REG_CORE_MEASUREMENT_SETUPn_COUNT    13
#define REG_CORE_HIGH_THRESHOLD_LIMITn_RESET 0x7F800000            /*      Reset Value for High_Threshold_Limit[n]  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT0_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT0  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT1_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT1  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT2_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT2  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT3_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT3  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT4_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT4  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT5_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT5  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT6_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT6  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT7_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT7  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT8_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT8  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT9_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT9  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT10_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT10  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT11_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT11  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT12_RESET 0x7F800000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT12  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT0       0x000000A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT1       0x000000E0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT2       0x00000120            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT3       0x00000160            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT4       0x000001A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT5       0x000001E0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT6       0x00000220            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT7       0x00000260            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT8       0x000002A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT9       0x000002E0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT10      0x00000320            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT11      0x00000360            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT12      0x000003A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMITn(i)    (REG_CORE_HIGH_THRESHOLD_LIMIT0 + ((i) * 64))
#define REG_CORE_HIGH_THRESHOLD_LIMITn_COUNT 13
#define REG_CORE_LOW_THRESHOLD_LIMITn_RESET  0xFF800000            /*      Reset Value for Low_Threshold_Limit[n]  */
#define REG_CORE_LOW_THRESHOLD_LIMIT0_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT0  */
#define REG_CORE_LOW_THRESHOLD_LIMIT1_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT1  */
#define REG_CORE_LOW_THRESHOLD_LIMIT2_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT2  */
#define REG_CORE_LOW_THRESHOLD_LIMIT3_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT3  */
#define REG_CORE_LOW_THRESHOLD_LIMIT4_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT4  */
#define REG_CORE_LOW_THRESHOLD_LIMIT5_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT5  */
#define REG_CORE_LOW_THRESHOLD_LIMIT6_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT6  */
#define REG_CORE_LOW_THRESHOLD_LIMIT7_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT7  */
#define REG_CORE_LOW_THRESHOLD_LIMIT8_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT8  */
#define REG_CORE_LOW_THRESHOLD_LIMIT9_RESET  0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT9  */
#define REG_CORE_LOW_THRESHOLD_LIMIT10_RESET 0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT10  */
#define REG_CORE_LOW_THRESHOLD_LIMIT11_RESET 0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT11  */
#define REG_CORE_LOW_THRESHOLD_LIMIT12_RESET 0xFF800000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT12  */
#define REG_CORE_LOW_THRESHOLD_LIMIT0        0x000000A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT1        0x000000E4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT2        0x00000124            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT3        0x00000164            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT4        0x000001A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT5        0x000001E4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT6        0x00000224            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT7        0x00000264            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT8        0x000002A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT9        0x000002E4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT10       0x00000324            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT11       0x00000364            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT12       0x000003A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMITn(i)     (REG_CORE_LOW_THRESHOLD_LIMIT0 + ((i) * 64))
#define REG_CORE_LOW_THRESHOLD_LIMITn_COUNT  13
#define REG_CORE_SENSOR_OFFSETn_RESET        0x00000000            /*      Reset Value for Sensor_Offset[n]  */
#define REG_CORE_SENSOR_OFFSET0_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET0  */
#define REG_CORE_SENSOR_OFFSET1_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET1  */
#define REG_CORE_SENSOR_OFFSET2_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET2  */
#define REG_CORE_SENSOR_OFFSET3_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET3  */
#define REG_CORE_SENSOR_OFFSET4_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET4  */
#define REG_CORE_SENSOR_OFFSET5_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET5  */
#define REG_CORE_SENSOR_OFFSET6_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET6  */
#define REG_CORE_SENSOR_OFFSET7_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET7  */
#define REG_CORE_SENSOR_OFFSET8_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET8  */
#define REG_CORE_SENSOR_OFFSET9_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET9  */
#define REG_CORE_SENSOR_OFFSET10_RESET       0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET10  */
#define REG_CORE_SENSOR_OFFSET11_RESET       0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET11  */
#define REG_CORE_SENSOR_OFFSET12_RESET       0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET12  */
#define REG_CORE_SENSOR_OFFSET0              0x000000A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET1              0x000000E8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET2              0x00000128            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET3              0x00000168            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET4              0x000001A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET5              0x000001E8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET6              0x00000228            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET7              0x00000268            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET8              0x000002A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET9              0x000002E8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET10             0x00000328            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET11             0x00000368            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET12             0x000003A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSETn(i)           (REG_CORE_SENSOR_OFFSET0 + ((i) * 64))
#define REG_CORE_SENSOR_OFFSETn_COUNT        13
#define REG_CORE_SENSOR_GAINn_RESET          0x3F800000            /*      Reset Value for Sensor_Gain[n]  */
#define REG_CORE_SENSOR_GAIN0_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN0  */
#define REG_CORE_SENSOR_GAIN1_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN1  */
#define REG_CORE_SENSOR_GAIN2_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN2  */
#define REG_CORE_SENSOR_GAIN3_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN3  */
#define REG_CORE_SENSOR_GAIN4_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN4  */
#define REG_CORE_SENSOR_GAIN5_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN5  */
#define REG_CORE_SENSOR_GAIN6_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN6  */
#define REG_CORE_SENSOR_GAIN7_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN7  */
#define REG_CORE_SENSOR_GAIN8_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN8  */
#define REG_CORE_SENSOR_GAIN9_RESET          0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN9  */
#define REG_CORE_SENSOR_GAIN10_RESET         0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN10  */
#define REG_CORE_SENSOR_GAIN11_RESET         0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN11  */
#define REG_CORE_SENSOR_GAIN12_RESET         0x3F800000            /*      Reset Value for REG_CORE_SENSOR_GAIN12  */
#define REG_CORE_SENSOR_GAIN0                0x000000AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN1                0x000000EC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN2                0x0000012C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN3                0x0000016C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN4                0x000001AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN5                0x000001EC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN6                0x0000022C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN7                0x0000026C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN8                0x000002AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN9                0x000002EC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN10               0x0000032C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN11               0x0000036C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN12               0x000003AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAINn(i)             (REG_CORE_SENSOR_GAIN0 + ((i) * 64))
#define REG_CORE_SENSOR_GAINn_COUNT          13
#define REG_CORE_CHANNEL_SKIPn_RESET         0x00000000            /*      Reset Value for Channel_Skip[n]  */
#define REG_CORE_CHANNEL_SKIP0_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP0  */
#define REG_CORE_CHANNEL_SKIP1_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP1  */
#define REG_CORE_CHANNEL_SKIP2_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP2  */
#define REG_CORE_CHANNEL_SKIP3_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP3  */
#define REG_CORE_CHANNEL_SKIP4_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP4  */
#define REG_CORE_CHANNEL_SKIP5_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP5  */
#define REG_CORE_CHANNEL_SKIP6_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP6  */
#define REG_CORE_CHANNEL_SKIP7_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP7  */
#define REG_CORE_CHANNEL_SKIP8_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP8  */
#define REG_CORE_CHANNEL_SKIP9_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP9  */
#define REG_CORE_CHANNEL_SKIP10_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP10  */
#define REG_CORE_CHANNEL_SKIP11_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP11  */
#define REG_CORE_CHANNEL_SKIP12_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP12  */
#define REG_CORE_CHANNEL_SKIP0               0x000000B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP1               0x000000F2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP2               0x00000132            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP3               0x00000172            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP4               0x000001B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP5               0x000001F2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP6               0x00000232            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP7               0x00000272            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP8               0x000002B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP9               0x000002F2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP10              0x00000332            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP11              0x00000372            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP12              0x000003B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIPn(i)            (REG_CORE_CHANNEL_SKIP0 + ((i) * 64))
#define REG_CORE_CHANNEL_SKIPn_COUNT         13
#define REG_CORE_DIGITAL_SENSOR_CONFIGn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Config[n]  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG0_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG0  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG1_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG1  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG2_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG2  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG3_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG3  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG4_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG4  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG5_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG5  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG6_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG6  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG7_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG7  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG8_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG8  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG9_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG9  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG10  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG11  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG12  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG0      0x000000BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG1      0x000000FC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG2      0x0000013C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG3      0x0000017C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG4      0x000001BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG5      0x000001FC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG6      0x0000023C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG7      0x0000027C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG8      0x000002BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG9      0x000002FC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG10     0x0000033C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG11     0x0000037C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG12     0x000003BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIGn(i)   (REG_CORE_DIGITAL_SENSOR_CONFIG0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_CONFIGn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_ADDRESSn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Address[n]  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS0_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS0  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS1_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS1  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS2_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS2  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS3_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS3  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS4_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS4  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS5_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS5  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS6_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS6  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS7_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS7  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS8_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS8  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS9_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS9  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS10  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS11  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS12  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS0     0x000000BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS1     0x000000FE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS2     0x0000013E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS3     0x0000017E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS4     0x000001BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS5     0x000001FE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS6     0x0000023E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS7     0x0000027E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS8     0x000002BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS9     0x000002FE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS10    0x0000033E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS11    0x0000037E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS12    0x000003BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESSn(i)  (REG_CORE_DIGITAL_SENSOR_ADDRESS0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_ADDRESSn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMSn_RESET 0x00000006            /*      Reset Value for Digital_Sensor_Comms[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMS0_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS0  */
#define REG_CORE_DIGITAL_SENSOR_COMMS1_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS1  */
#define REG_CORE_DIGITAL_SENSOR_COMMS2_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS2  */
#define REG_CORE_DIGITAL_SENSOR_COMMS3_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS3  */
#define REG_CORE_DIGITAL_SENSOR_COMMS4_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS4  */
#define REG_CORE_DIGITAL_SENSOR_COMMS5_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS5  */
#define REG_CORE_DIGITAL_SENSOR_COMMS6_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS6  */
#define REG_CORE_DIGITAL_SENSOR_COMMS7_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS7  */
#define REG_CORE_DIGITAL_SENSOR_COMMS8_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS8  */
#define REG_CORE_DIGITAL_SENSOR_COMMS9_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS9  */
#define REG_CORE_DIGITAL_SENSOR_COMMS10_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS10  */
#define REG_CORE_DIGITAL_SENSOR_COMMS11_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS11  */
#define REG_CORE_DIGITAL_SENSOR_COMMS12_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS12  */
#define REG_CORE_DIGITAL_SENSOR_COMMS0       0x000000C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS1       0x00000100            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS2       0x00000140            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS3       0x00000180            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS4       0x000001C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS5       0x00000200            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS6       0x00000240            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS7       0x00000280            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS8       0x000002C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS9       0x00000300            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS10      0x00000340            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS11      0x00000380            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS12      0x000003C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMSn(i)    (REG_CORE_DIGITAL_SENSOR_COMMS0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMSn_COUNT 13

/* ============================================================================================================================
        CORE Register BitMasks, Positions & Enumerations 
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          CORE_COMMAND                         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_COMMAND_SPECIAL_COMMAND     0            /*  Special Command */
#define BITM_CORE_COMMAND_SPECIAL_COMMAND    0x000000FF    /*  Special Command */
#define ENUM_CORE_COMMAND_NOP                0x00000000            /*  Special_Command: No command */
#define ENUM_CORE_COMMAND_CONVERT            0x00000001            /*  Special_Command: Start ADC conversions */
#define ENUM_CORE_COMMAND_CONVERT_WITH_RAW   0x00000002            /*  Special_Command: Start conversions with added raw ADC data */
#define ENUM_CORE_COMMAND_LATCH_CONFIG       0x00000007            /*  Special_Command: Latch configuration. */
#define ENUM_CORE_COMMAND_LOAD_LUT           0x00000008            /*  Special_Command: Load LUT from flash */
#define ENUM_CORE_COMMAND_SAVE_LUT           0x00000009            /*  Special_Command: Save LUT to flash */
#define ENUM_CORE_COMMAND_LOAD_CONFIG_1      0x00000018            /*  Special_Command: Load registers with configuration from flash */
#define ENUM_CORE_COMMAND_SAVE_CONFIG_1      0x00000019            /*  Special_Command: Store current registers to flash configuration */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_MODE                            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_MODE_DRDY_MODE              2            /*  Indicates Behavior of DRDY Pin */
#define BITP_CORE_MODE_CONVERSION_MODE        0            /*  Conversion Mode */
#define BITM_CORE_MODE_DRDY_MODE             0x0000000C    /*  Indicates Behavior of DRDY Pin */
#define BITM_CORE_MODE_CONVERSION_MODE       0x00000003    /*  Conversion Mode */
#define ENUM_CORE_MODE_DRDY_PER_CONVERSION   0x00000000            /*  Drdy_Mode: Data ready per conversion */
#define ENUM_CORE_MODE_DRDY_PER_CYCLE        0x00000004            /*  Drdy_Mode: Data ready per cycle */
#define ENUM_CORE_MODE_SINGLECYCLE           0x00000000            /*  Conversion_Mode: Single cycle conversion mode. A cycle is completed every time a convert command is issued */
#define ENUM_CORE_MODE_RESERVED              0x00000001            /*  Conversion_Mode: Reserved for future use */
#define ENUM_CORE_MODE_CONTINUOUS            0x00000002            /*  Conversion_Mode: Continuous conversion mode. A cycle is started repeatedly at time specified in cycle time */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_POWER_CONFIG                    Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_POWER_CONFIG_POWER_MODE_MCU  0            /*  MCU Power Mode */
#define BITM_CORE_POWER_CONFIG_POWER_MODE_MCU 0x00000001    /*  MCU Power Mode */
#define ENUM_CORE_POWER_CONFIG_ACTIVE_MODE   0x00000000            /*  Power_Mode_MCU: ADMW1001 is fully power up and ready to convert */
#define ENUM_CORE_POWER_CONFIG_HIBERNATION   0x00000001            /*  Power_Mode_MCU: Lowest power mode. wakeup pin required to enter active mode. SPI powered down */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CYCLE_CONTROL                   Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CYCLE_CONTROL_CYCLE_TIME_UNITS 14            /*  Units for Cycle Time */
#define BITP_CORE_CYCLE_CONTROL_VBIAS        13            /*  Voltage Bias Global Enable */
#define BITP_CORE_CYCLE_CONTROL_CYCLE_TIME    0            /*  Time Between Measurement Cycles */
#define BITM_CORE_CYCLE_CONTROL_CYCLE_TIME_UNITS 0x00004000    /*  Units for Cycle Time */
#define BITM_CORE_CYCLE_CONTROL_VBIAS        0x00002000    /*  Voltage Bias Global Enable */
#define BITM_CORE_CYCLE_CONTROL_CYCLE_TIME   0x00000FFF    /*  Time Between Measurement Cycles */
#define ENUM_CORE_CYCLE_CONTROL_MILLISECONDS 0x00000000            /*  Cycle_Time_Units: Milli-seconds */
#define ENUM_CORE_CYCLE_CONTROL_SECONDS      0x00004000            /*  Cycle_Time_Units: Seconds */
#define ENUM_CORE_CYCLE_CONTROL_VBIAS_DISABLE 0x00000000            /*  Vbias: Vbias disabled */
#define ENUM_CORE_CYCLE_CONTROL_VBIAS_ENABLE 0x00002000            /*  Vbias: Enable Vbias output for the duration of a cycle */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_FIFO_NUM_CYCLES                 Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_FIFO_NUM_CYCLES_FIFO_NUM_CYCLES  0            /*  Number of Cycles to Fill the FIFO */
#define BITM_CORE_FIFO_NUM_CYCLES_FIFO_NUM_CYCLES 0x000000FF    /*  Number of Cycles to Fill the FIFO */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_STATUS                          Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_STATUS_LUT_ERROR            7            /*  Indicates Error with One or More Lookup Tables */
#define BITP_CORE_STATUS_DIAG_CHECKSUM_ERROR  6            /*  Indicates Error on Internal Checksum Calculations */
#define BITP_CORE_STATUS_FIFO_ERROR           5            /*  Indicates Error with FIFO */
#define BITP_CORE_STATUS_CMD_RUNNING          4            /*  Indicates Special Command Active */
#define BITP_CORE_STATUS_DRDY                 3            /*  Indicates New Sensor Result Available to Read */
#define BITP_CORE_STATUS_ERROR                2            /*  Indicates an Error */
#define BITP_CORE_STATUS_ALERT_ACTIVE         1            /*  Indicates One or More Sensor Alerts Active */
#define BITP_CORE_STATUS_CONFIGURATION_ERROR  0            /*  Indicates Error with Programmed Configuration */
#define BITM_CORE_STATUS_LUT_ERROR           0x00000080    /*  Indicates Error with One or More Lookup Tables */
#define BITM_CORE_STATUS_DIAG_CHECKSUM_ERROR 0x00000040    /*  Indicates Error on Internal Checksum Calculations */
#define BITM_CORE_STATUS_FIFO_ERROR          0x00000020    /*  Indicates Error with FIFO */
#define BITM_CORE_STATUS_CMD_RUNNING         0x00000010    /*  Indicates Special Command Active */
#define BITM_CORE_STATUS_DRDY                0x00000008    /*  Indicates New Sensor Result Available to Read */
#define BITM_CORE_STATUS_ERROR               0x00000004    /*  Indicates an Error */
#define BITM_CORE_STATUS_ALERT_ACTIVE        0x00000002    /*  Indicates One or More Sensor Alerts Active */
#define BITM_CORE_STATUS_CONFIGURATION_ERROR 0x00000001    /*  Indicates Error with Programmed Configuration */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_ALERT_STATUS            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH12 12            /*  Indicates Channel 12 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH11 11            /*  Indicates Channel 11 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH10 10            /*  Indicates Channel 10 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH9  9            /*  Indicates Channel 9 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH8  8            /*  Indicates Channel 8 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH7  7            /*  Indicates Channel 7 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH6  6            /*  Indicates Channel 6 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH5  5            /*  Indicates Channel 5Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH4  4            /*  Indicates Channel 4 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH3  3            /*  Indicates Channel 3 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH2  2            /*  Indicates Channel 2 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH1  1            /*  Indicates Channel 1 Alert Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH0  0            /*  Indicates Channel 0 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH12 0x00001000    /*  Indicates Channel 12 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH11 0x00000800    /*  Indicates Channel 11 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH10 0x00000400    /*  Indicates Channel 10 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH9 0x00000200    /*  Indicates Channel 9 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH8 0x00000100    /*  Indicates Channel 8 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH7 0x00000080    /*  Indicates Channel 7 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH6 0x00000040    /*  Indicates Channel 6 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH5 0x00000020    /*  Indicates Channel 5Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH4 0x00000010    /*  Indicates Channel 4 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH3 0x00000008    /*  Indicates Channel 3 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH2 0x00000004    /*  Indicates Channel 2 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH1 0x00000002    /*  Indicates Channel 1 Alert Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH0 0x00000001    /*  Indicates Channel 0 Alert Active */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ALERT_DETAIL_CH[n]              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ALERT_DETAIL_CH_SENSOR_HARDFAULT  7            /*  Indicates Sensor Hard Fault */
#define BITP_CORE_ALERT_DETAIL_CH_ADC_INPUT_OVERRANGE  6            /*  Indicates the ADC Input is Overrange */
#define BITP_CORE_ALERT_DETAIL_CH_CJ_HARD_FAULT  5            /*  Cold Junction Hard Fault */
#define BITP_CORE_ALERT_DETAIL_CH_CJ_SOFT_FAULT  4            /*  Cold Junction Soft Fault */
#define BITP_CORE_ALERT_DETAIL_CH_SENSOR_OVERRANGE  3            /*  Indicates If the Sensor is Overrange */
#define BITP_CORE_ALERT_DETAIL_CH_SENSOR_UNDERRANGE  2            /*  Indicates If the Sensor is Underrange */
#define BITP_CORE_ALERT_DETAIL_CH_ADC_NEAR_OVERRANGE  1            /*  Indicates If the ADC is Near Overrange */
#define BITP_CORE_ALERT_DETAIL_CH_RESULT_VALID  0            /*  Set If a Result is Valid */
#define BITM_CORE_ALERT_DETAIL_CH_SENSOR_HARDFAULT 0x00000080    /*  Indicates Sensor Hard Fault */
#define BITM_CORE_ALERT_DETAIL_CH_ADC_INPUT_OVERRANGE 0x00000040    /*  Indicates the ADC Input is Overrange */
#define BITM_CORE_ALERT_DETAIL_CH_CJ_HARD_FAULT 0x00000020    /*  Cold Junction Hard Fault */
#define BITM_CORE_ALERT_DETAIL_CH_CJ_SOFT_FAULT 0x00000010    /*  Cold Junction Soft Fault */
#define BITM_CORE_ALERT_DETAIL_CH_SENSOR_OVERRANGE 0x00000008    /*  Indicates If the Sensor is Overrange */
#define BITM_CORE_ALERT_DETAIL_CH_SENSOR_UNDERRANGE 0x00000004    /*  Indicates If the Sensor is Underrange */
#define BITM_CORE_ALERT_DETAIL_CH_ADC_NEAR_OVERRANGE 0x00000002    /*  Indicates If the ADC is Near Overrange */
#define BITM_CORE_ALERT_DETAIL_CH_RESULT_VALID 0x00000001    /*  Set If a Result is Valid */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ERROR_CODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ERROR_CODE_ERROR_CODE       0            /*  Code Indicating Type of Error */
#define BITM_CORE_ERROR_CODE_ERROR_CODE      0x0000FFFF    /*  Code Indicating Type of Error */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_EXTERNAL_REFERENCE_RESISTOR     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_EXTERNAL_REFERENCE_RESISTOR_EXT_REFIN1_VALUE  0            /*  External Reference Resistor Value */
#define BITM_CORE_EXTERNAL_REFERENCE_RESISTOR_EXT_REFIN1_VALUE 0xFFFFFFFF    /*  External Reference Resistor Value */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIAGNOSTICS_CONTROL             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIAGNOSTICS_CONTROL_DIAG_OSD_FREQ  1            /*  Diagnostics Open Sensor Detect Frequency */
#define BITP_CORE_DIAGNOSTICS_CONTROL_DIAG_MEAS_EN  0            /*  Diagnostics Measure Enable */
#define BITM_CORE_DIAGNOSTICS_CONTROL_DIAG_OSD_FREQ 0x00000006    /*  Diagnostics Open Sensor Detect Frequency */
#define BITM_CORE_DIAGNOSTICS_CONTROL_DIAG_MEAS_EN 0x00000001    /*  Diagnostics Measure Enable */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_OFF 0x00000000            /*  Diag_OSD_Freq: No Open-Circuit Detection During Measurement */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1_CYCLE 0x00000002            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Measurement Cycle */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_PER_10_CYCLES 0x00000004            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Ten Measurement Cycles */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_PER_100_CYCLES 0x00000006            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Hundred Measurement Cycles */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DATA_FIFO                       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DATA_FIFO_DATA_FIFO         0            /*  FIFO Buffer of Sensor Results */
#define BITM_CORE_DATA_FIFO_DATA_FIFO        0x000000FF    /*  FIFO Buffer of Sensor Results */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DEBUG_CODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DEBUG_CODE_DEBUG_CODE       0            /*  Additional Information on Source of Alert or Errors */
#define BITM_CORE_DEBUG_CODE_DEBUG_CODE      0xFFFFFFFF    /*  Additional Information on Source of Alert or Errors */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_TEST_REG_ACCESS                 Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_TEST_REG_ACCESS_TEST_ACCESS  0            /*  Test Register Access. Specific Write Sequence Required */
#define BITM_CORE_TEST_REG_ACCESS_TEST_ACCESS 0x0000FFFF    /*  Test Register Access. Specific Write Sequence Required */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LUT_SELECT                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LUT_SELECT_LUT_RW           7            /*  Read or Write LUT Data */
#define BITM_CORE_LUT_SELECT_LUT_RW          0x00000080    /*  Read or Write LUT Data */
#define ENUM_CORE_LUT_SELECT_LUT_READ        0x00000000            /*  LUT_RW: Read addressed LUT data */
#define ENUM_CORE_LUT_SELECT_LUT_WRITE       0x00000080            /*  LUT_RW: Write addressed LUT data */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LUT_OFFSET                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LUT_OFFSET_LUT_OFFSET       0            /*  Offset into the Lookup Table */
#define BITM_CORE_LUT_OFFSET_LUT_OFFSET      0x00003FFF    /*  Offset into the Lookup Table */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LUT_DATA                        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LUT_DATA_LUT_DATA           0            /*  Data Byte to Write to and Read from the Lookup Table */
#define BITM_CORE_LUT_DATA_LUT_DATA          0x000000FF    /*  Data Byte to Write to and Read from the Lookup Table */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_REVISION                        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_REVISION_REV_MAJOR         24            /*  Major Revision Information */
#define BITP_CORE_REVISION_REV_MINOR         16            /*  Minor Revision Information */
#define BITP_CORE_REVISION_REV_PATCH          0            /*  Patch Revision Information */
#define BITM_CORE_REVISION_REV_MAJOR         0xFF000000    /*  Major Revision Information */
#define BITM_CORE_REVISION_REV_MINOR         0x00FF0000    /*  Minor Revision Information */
#define BITM_CORE_REVISION_REV_PATCH         0x0000FFFF    /*  Patch Revision Information */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_COUNT[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_COUNT_CHANNEL_ENABLE  7            /*  Enable Channel in Measurement Cycle */
#define BITP_CORE_CHANNEL_COUNT_CHANNEL_COUNT  0            /*  How Many Times Channel Appears in One Cycle */
#define BITM_CORE_CHANNEL_COUNT_CHANNEL_ENABLE 0x00000080    /*  Enable Channel in Measurement Cycle */
#define BITM_CORE_CHANNEL_COUNT_CHANNEL_COUNT 0x0000007F    /*  How Many Times Channel Appears in One Cycle */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_OPTIONS[n]              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_OPTIONS_CHANNEL_PRIORITY  0            /*  Indicates Priority or Position of This Channel in Sequence */
#define BITM_CORE_CHANNEL_OPTIONS_CHANNEL_PRIORITY 0x0000000F    /*  Indicates Priority or Position of This Channel in Sequence */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_TYPE[n]                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_TYPE_SENSOR_TYPE     0            /*  Sensor Type */
#define BITM_CORE_SENSOR_TYPE_SENSOR_TYPE    0x00000FFF    /*  Sensor Type */
#define ENUM_CORE_SENSOR_TYPE_THERMOCOUPLE_T 0x00000000            /*  Sensor_Type: Thermocouple T-Type sensor */
#define ENUM_CORE_SENSOR_TYPE_THERMOCOUPLE_J 0x00000001            /*  Sensor_Type: Thermocouple J-Type Sensor */
#define ENUM_CORE_SENSOR_TYPE_THERMOCOUPLE_K 0x00000002            /*  Sensor_Type: Thermocouple K-Type Sensor */
#define ENUM_CORE_SENSOR_TYPE_RTD_2W_PT100   0x00000020            /*  Sensor_Type: RTD 2 wire PT100 sensor */
#define ENUM_CORE_SENSOR_TYPE_RTD_2W_PT1000  0x00000021            /*  Sensor_Type: RTD 2 wire PT1000 sensor */
#define ENUM_CORE_SENSOR_TYPE_RTD_3W_PT100   0x00000040            /*  Sensor_Type: RTD 3 wire PT100 sensor */
#define ENUM_CORE_SENSOR_TYPE_RTD_3W_PT1000  0x00000041            /*  Sensor_Type: RTD 3 wire PT1000 sensor */
#define ENUM_CORE_SENSOR_TYPE_RTD_4W_PT100   0x00000060            /*  Sensor_Type: RTD 4 wire PT100 sensor */
#define ENUM_CORE_SENSOR_TYPE_RTD_4W_PT1000  0x00000061            /*  Sensor_Type: RTD 4 wire PT1000 sensor */
#define ENUM_CORE_SENSOR_TYPE_BRIDGE_4W      0x000000A9            /*  Sensor_Type: Bridge 4 wire sensor */
#define ENUM_CORE_SENSOR_TYPE_CUSTOM1        0x00000400            /*  Sensor_Type: Custom1 */
#define ENUM_CORE_SENSOR_TYPE_I2C_HUMIDITY_B 0x00000841            /*  Sensor_Type: I2C humidity sensor B */
#define ENUM_CORE_SENSOR_TYPE_SENSOR_RESERVED_1 0x00000FE0            /*  Sensor_Type: RESERVED. NOT TO BE USED */
#define ENUM_CORE_SENSOR_TYPE_SENSOR_RESERVED_2 0x00000FFF            /*  Sensor_Type: RESERVED. NOT TO BE USED */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_DETAILS[n]               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_DETAILS_COMPENSATION_DISABLE 31            /*  This Bit Indicates Compensation Data Must Not Be Used */
#define BITP_CORE_SENSOR_DETAILS_RTD_CURVE   27            /*  Select RTD Curve for Linearization */
#define BITP_CORE_SENSOR_DETAILS_PGA_GAIN    24            /*  PGA Gain */
#define BITP_CORE_SENSOR_DETAILS_REFERENCE_SELECT 20            /*  Reference Selection */
#define BITP_CORE_SENSOR_DETAILS_DO_NOT_PUBLISH 17            /*  Do Not Publish Channel Result */
#define BITP_CORE_SENSOR_DETAILS_LUT_SELECT  15            /*  Lookup Table Select */
#define BITP_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL  4            /*  Indicates Which Channel Used to Compensate the Sensor Result */
#define BITP_CORE_SENSOR_DETAILS_MEASUREMENT_UNITS  0            /*  Units of Sensor Measurement */
#define BITM_CORE_SENSOR_DETAILS_COMPENSATION_DISABLE 0x80000000    /*  This Bit Indicates Compensation Data Must Not Be Used */
#define BITM_CORE_SENSOR_DETAILS_RTD_CURVE   0x18000000    /*  Select RTD Curve for Linearization */
#define BITM_CORE_SENSOR_DETAILS_PGA_GAIN    0x07000000    /*  PGA Gain */
#define BITM_CORE_SENSOR_DETAILS_REFERENCE_SELECT 0x00F00000    /*  Reference Selection */
#define BITM_CORE_SENSOR_DETAILS_DO_NOT_PUBLISH 0x00020000    /*  Do Not Publish Channel Result */
#define BITM_CORE_SENSOR_DETAILS_LUT_SELECT  0x00018000    /*  Lookup Table Select */
#define BITM_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL 0x000000F0    /*  Indicates Which Channel Used to Compensate the Sensor Result */
#define BITM_CORE_SENSOR_DETAILS_MEASUREMENT_UNITS 0x0000000F    /*  Units of Sensor Measurement */
#define ENUM_CORE_SENSOR_DETAILS_EUROPEAN_CURVE 0x00000000            /*  RTD_Curve: European curve */
#define ENUM_CORE_SENSOR_DETAILS_AMERICAN_CURVE 0x08000000            /*  RTD_Curve: American curve */
#define ENUM_CORE_SENSOR_DETAILS_JAPANESE_CURVE 0x10000000            /*  RTD_Curve: Japanese curve */
#define ENUM_CORE_SENSOR_DETAILS_ITS90_CURVE 0x18000000            /*  RTD_Curve: ITS-90 curve */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_1  0x00000000            /*  PGA_Gain: Gain of 1 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_2  0x01000000            /*  PGA_Gain: Gain of 2 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_4  0x02000000            /*  PGA_Gain: Gain of 4 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_8  0x03000000            /*  PGA_Gain: Gain of 8 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_16 0x04000000            /*  PGA_Gain: Gain of 16 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_32 0x05000000            /*  PGA_Gain: Gain of 32 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_64 0x06000000            /*  PGA_Gain: Gain of 64 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_128 0x07000000            /*  PGA_Gain: Gain of 128 */
#define ENUM_CORE_SENSOR_DETAILS_REF_VINT    0x00000000            /*  Reference_Select: Internal voltage reference (1.2V) */
#define ENUM_CORE_SENSOR_DETAILS_REF_VEXT1   0x00100000            /*  Reference_Select: External voltage reference applied to VERF+ and VREF- */
#define ENUM_CORE_SENSOR_DETAILS_REF_AVDD    0x00300000            /*  Reference_Select: AVDD supply internally used as reference */
#define ENUM_CORE_SENSOR_DETAILS_LUT_DEFAULT 0x00000000            /*  LUT_Select: Default lookup table for selected sensor type */
#define ENUM_CORE_SENSOR_DETAILS_LUT_UNITY   0x00008000            /*  LUT_Select: Unity lookup table. 1:1 mapping from input to output */
#define ENUM_CORE_SENSOR_DETAILS_LUT_CUSTOM  0x00010000            /*  LUT_Select: User defined custom lookup table. */
#define ENUM_CORE_SENSOR_DETAILS_LUT_RESERVED 0x00018000            /*  LUT_Select: Reserved */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_UNSPECIFIED 0x00000000            /*  Measurement_Units: Not Specified */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_RESERVED 0x00000001            /*  Measurement_Units: Reserved */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_DEGC  0x00000002            /*  Measurement_Units: Degrees C */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_DEGF  0x00000003            /*  Measurement_Units: Degrees F */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_EXCITATION[n]           Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_EXCITATION_IOUT_EXCITATION_CURRENT  0            /*  Current Source Value */
#define BITM_CORE_CHANNEL_EXCITATION_IOUT_EXCITATION_CURRENT 0x0000000F    /*  Current Source Value */
#define ENUM_CORE_CHANNEL_EXCITATION_NONE    0x00000000            /*  IOUT_Excitation_Current: Excitation Current Disabled */
#define ENUM_CORE_CHANNEL_EXCITATION_RESERVED 0x00000001            /*  IOUT_Excitation_Current: Reserved */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_10UA 0x00000002            /*  IOUT_Excitation_Current: 10 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_RESERVED2 0x00000003            /*  IOUT_Excitation_Current: Reserved */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_50UA 0x00000004            /*  IOUT_Excitation_Current: 50 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_100UA 0x00000005            /*  IOUT_Excitation_Current: 100 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_250UA 0x00000006            /*  IOUT_Excitation_Current: 250 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_500UA 0x00000007            /*  IOUT_Excitation_Current: 500 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_1000UA 0x00000008            /*  IOUT_Excitation_Current: 1000 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_EXTERNAL 0x0000000F            /*  IOUT_Excitation_Current: External current sourced */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SETTLING_TIME[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SETTLING_TIME_SETTLING_TIME_UNITS 14            /*  Units for Settling Time */
#define BITP_CORE_SETTLING_TIME_SETTLING_TIME  0            /*  Settling Time to Allow When Switching to Channel */
#define BITM_CORE_SETTLING_TIME_SETTLING_TIME_UNITS 0x0000C000    /*  Units for Settling Time */
#define BITM_CORE_SETTLING_TIME_SETTLING_TIME 0x00003FFF    /*  Settling Time to Allow When Switching to Channel */
#define ENUM_CORE_SETTLING_TIME_MICROSECONDS 0x00000000            /*  Settling_Time_Units: Micro-seconds */
#define ENUM_CORE_SETTLING_TIME_MILLISECONDS 0x00004000            /*  Settling_Time_Units: Milli-seconds */
#define ENUM_CORE_SETTLING_TIME_SECONDS      0x00008000            /*  Settling_Time_Units: Seconds */
#define ENUM_CORE_SETTLING_TIME_UNDEFINED    0x0000C000            /*  Settling_Time_Units: Undefined */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_MEASUREMENT_SETUP[n]            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_MEASUREMENT_SETUP_BUFFER_BYPASS 15            /*  Disable Buffers */
#define BITP_CORE_MEASUREMENT_SETUP_GND_SW   13            /*  Ground Switch Selection */
#define BITP_CORE_MEASUREMENT_SETUP_ADC_FILTER_TYPE 12            /*  ADC Digital Filter Type */
#define BITP_CORE_MEASUREMENT_SETUP_CHOP_MODE 10            /*  Enabled and Disable Chop Mode */
#define BITP_CORE_MEASUREMENT_SETUP_PST_MEAS_EXC_CTRL  9            /*  Disable Current Sources After Measurement Completes */
#define BITP_CORE_MEASUREMENT_SETUP_NOTCH_EN_2  8            /*  Enable Notch 2 Filter Mode */
#define BITP_CORE_MEASUREMENT_SETUP_ADC_SF    0            /*  ADC Digital Filter Speed */
#define BITM_CORE_MEASUREMENT_SETUP_BUFFER_BYPASS 0x00008000    /*  Disable Buffers */
#define BITM_CORE_MEASUREMENT_SETUP_GND_SW   0x00006000    /*  Ground Switch Selection */
#define BITM_CORE_MEASUREMENT_SETUP_ADC_FILTER_TYPE 0x00001000    /*  ADC Digital Filter Type */
#define BITM_CORE_MEASUREMENT_SETUP_CHOP_MODE 0x00000C00    /*  Enabled and Disable Chop Mode */
#define BITM_CORE_MEASUREMENT_SETUP_PST_MEAS_EXC_CTRL 0x00000200    /*  Disable Current Sources After Measurement Completes */
#define BITM_CORE_MEASUREMENT_SETUP_NOTCH_EN_2 0x00000100    /*  Enable Notch 2 Filter Mode */
#define BITM_CORE_MEASUREMENT_SETUP_ADC_SF   0x0000007F    /*  ADC Digital Filter Speed */
#define ENUM_CORE_MEASUREMENT_SETUP_BUFFERS_ENABLED 0x00000000            /*  Buffer_Bypass: Input buffers enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_BUFFERS_DISABLED 0x00008000            /*  Buffer_Bypass: Input buffers disabled */
#define ENUM_CORE_MEASUREMENT_SETUP_GND_SW_OPEN 0x00000000            /*  GND_SW: GND_SW Open. The ground switch is not enabled for the sensor measurement */
#define ENUM_CORE_MEASUREMENT_SETUP_GND_SW_CLOSED 0x00002000            /*  GND_SW: GND_SW Closed. The ground switch is enabled for the sensor measurement, bit wiil Remain Closed After the Measurement */
#define ENUM_CORE_MEASUREMENT_SETUP_ENABLE_SINC4 0x00000000            /*  ADC_Filter_Type: Enabled SINC4 filter */
#define ENUM_CORE_MEASUREMENT_SETUP_ENABLE_SINC3 0x00001000            /*  ADC_Filter_Type: Enabled SINC3 filter */
#define ENUM_CORE_MEASUREMENT_SETUP_DISABLE_CHOP 0x00000000            /*  Chop_Mode: ADC front end chopping disabled */
#define ENUM_CORE_MEASUREMENT_SETUP_HW_CHOP  0x00000400            /*  Chop_Mode: Hardware chopping enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_SW_CHOP  0x00000800            /*  Chop_Mode: SW chop enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_HW_SW_CHOP 0x00000C00            /*  Chop_Mode: Hardware and software chop enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_POWERCYCLE 0x00000000
#define ENUM_CORE_MEASUREMENT_SETUP_ALWAYSON 0x00000200
#define ENUM_CORE_MEASUREMENT_SETUP_NOTCH_DIS 0x00000000            /*  NOTCH_EN_2: Disable notch filter */
#define ENUM_CORE_MEASUREMENT_SETUP_NOTCH_EN 0x00000100            /*  NOTCH_EN_2: Enable notch 2 filter option. */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_HIGH_THRESHOLD_LIMIT[n]         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_HIGH_THRESHOLD_LIMIT_HIGH_THRESHOLD  0            /*  Upper Limit for Sensor Alert Comparison */
#define BITM_CORE_HIGH_THRESHOLD_LIMIT_HIGH_THRESHOLD 0xFFFFFFFF    /*  Upper Limit for Sensor Alert Comparison */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LOW_THRESHOLD_LIMIT[n]          Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LOW_THRESHOLD_LIMIT_LOW_THRESHOLD  0            /*  Lower Limit for Sensor Alert Comparison */
#define BITM_CORE_LOW_THRESHOLD_LIMIT_LOW_THRESHOLD 0xFFFFFFFF    /*  Lower Limit for Sensor Alert Comparison */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_OFFSET[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_OFFSET_SENSOR_OFFSET  0            /*  Sensor Offset Adjustment */
#define BITM_CORE_SENSOR_OFFSET_SENSOR_OFFSET 0xFFFFFFFF    /*  Sensor Offset Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_GAIN[n]                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_GAIN_SENSOR_GAIN     0            /*  Sensor Gain Adjustment */
#define BITM_CORE_SENSOR_GAIN_SENSOR_GAIN    0xFFFFFFFF    /*  Sensor Gain Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_SKIP[n]                 Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_SKIP_CHANNEL_SKIP   0            /*  Indicates If Channel Will Skip Some Measurement Cycles */
#define BITM_CORE_CHANNEL_SKIP_CHANNEL_SKIP  0x000000FF    /*  Indicates If Channel Will Skip Some Measurement Cycles */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_CONFIG[n]        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_DATA_BITS 11            /*  Number of Relevant Data Bits */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_READ_BYTES  8            /*  Number of Bytes to Read from the Sensor */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_BIT_OFFSET  4            /*  Data Bit Offset, Relative to Alignment */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LEFT_ALIGNED  3            /*  Data Alignment Within the Data Frame */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LITTLE_ENDIAN  2            /*  Data Endianness of Sensor Result */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_CODING  0            /*  Data Encoding of Sensor Result */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_DATA_BITS 0x0000F800    /*  Number of Relevant Data Bits */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_READ_BYTES 0x00000700    /*  Number of Bytes to Read from the Sensor */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_BIT_OFFSET 0x000000F0    /*  Data Bit Offset, Relative to Alignment */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LEFT_ALIGNED 0x00000008    /*  Data Alignment Within the Data Frame */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LITTLE_ENDIAN 0x00000004    /*  Data Endianness of Sensor Result */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_CODING 0x00000003    /*  Data Encoding of Sensor Result */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_NONE 0x00000000            /*  Digital_Sensor_Coding: None/Invalid */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_UNIPOLAR 0x00000001            /*  Digital_Sensor_Coding: Unipolar */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_TWOS_COMPL 0x00000002            /*  Digital_Sensor_Coding: Twos complement */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_OFFSET_BINARY 0x00000003            /*  Digital_Sensor_Coding: Offset binary */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_ADDRESS[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_ADDRESS_DIGITAL_SENSOR_ADDRESS  0            /*  I2C Address or Write Address Command for SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_ADDRESS_DIGITAL_SENSOR_ADDRESS 0x000000FF    /*  I2C Address or Write Address Command for SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMS[n]         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE 10            /*  Configuration for Sensor SPI Protocol */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_I2C_CLOCK  5            /*  Controls SCLK Frequency for I2C Sensors */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_SPI_CLOCK  1            /*  Controls Clock Frequency for SPI Sensors */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_SENSOR_COMMS_EN  0            /*  Enable Digital Sensor Communications Register Parameters */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE 0x00000C00    /*  Configuration for Sensor SPI Protocol */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_I2C_CLOCK 0x00000060    /*  Controls SCLK Frequency for I2C Sensors */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_SPI_CLOCK 0x0000001E    /*  Controls Clock Frequency for SPI Sensors */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_SENSOR_COMMS_EN 0x00000001    /*  Enable Digital Sensor Communications Register Parameters */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_0 0x00000000            /*  SPI_Mode: Clock polarity = 0 Clock phase = 0 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_1 0x00000400            /*  SPI_Mode: Clock polarity = 0 Clock phase = 1 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_2 0x00000800            /*  SPI_Mode: Clock polarity = 1 Clock phase = 0 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_3 0x00000C00            /*  SPI_Mode: Clock polarity = 1 Clock phase = 1 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_100K 0x00000000            /*  I2C_Clock: 100kHz SCL */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_400K 0x00000020            /*  I2C_Clock: 400kHz SCL */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED1 0x00000040            /*  I2C_Clock: Reserved */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED2 0x00000060            /*  I2C_Clock: Reserved */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_8MHZ 0x00000000            /*  SPI_Clock: 8MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_4MHZ 0x00000002            /*  SPI_Clock: 4MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_2MHZ 0x00000004            /*  SPI_Clock: 2MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_1MHZ 0x00000006            /*  SPI_Clock: 1MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_500KHZ 0x00000008            /*  SPI_Clock: 500kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_250KHZ 0x0000000A            /*  SPI_Clock: 250kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_125KHZ 0x0000000C            /*  SPI_Clock: 125kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_62P5KHZ 0x0000000E            /*  SPI_Clock: 62.5kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_31P3KHZ 0x00000010            /*  SPI_Clock: 31.25kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_15P6KHZ 0x00000012            /*  SPI_Clock: 15.625kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_7P8KHZ 0x00000014            /*  SPI_Clock: 7.8kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_3P9KHZ 0x00000016            /*  SPI_Clock: 3.9kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_1P9KHZ 0x00000018            /*  SPI_Clock: 1.95kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_977HZ 0x0000001A            /*  SPI_Clock: 977Hz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_488HZ 0x0000001C            /*  SPI_Clock: 488Hz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_244HZ 0x0000001E            /*  SPI_Clock: 244Hz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_DEFAULT 0x00000000            /*  Digital_Sensor_Comms_En: Default parameters used for digital sensor communications */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_USER 0x00000001            /*  Digital_Sensor_Comms_En: User supplied parameters used for digital sensor communications */


/* SPI Parameters */

/***** SPI  */
#define PARAM_SPI_SPI_STANDARD          "LPT"             /*  A part must declare which SPI Standard it follows, either ADI or LPT  */
#define PARAM_SPI_CHIP_GRADE_VALUE          0             /*  This is used to indicate speed grades/linearity.  */
#define PARAM_SPI_CHIP_REVISION_VALUE          0             /*  This is used to indicate the silicon revision  */
#define PARAM_SPI_HAS_M_S_REGISTERS          0             /*  If a design uses Master-Slave registers this must be set to true to enable relevant control bit fields  */
#define PARAM_SPI_M_S_TRANSFER_BF_EXISTS          0             /*  Used to set EXISTS the M-S Transfer bit field  */
#define PARAM_SPI_STREAM_MODE_TRANSFER_BF_EXISTS          0             /*  Used to set EXISTS of the stream mode transfer bit field  */
#define PARAM_SPI_MSB_AND_LSB_FIRST_SUPPORT          0             /*  Determines if the parts supports MSB and LSB first options  */
#define PARAM_SPI_WIRE_MODE_SUPPORT  "_4_WIRE"             /*  Configures which hardware SPI modes are supported  */
#define PARAM_SPI_WIRE_MODE_DEFAULT  "_4_WIRE"             /*  Sets the default hardware SPI mode  */
#define PARAM_SPI_MULTI_IO_CHANNELS          1             /*  Defines the number of SDIO pins supported by the SPI in Multi-IO Mode. Should be 1,2,4, or 8.  */
#define PARAM_SPI_LPT_STANDARD_VERSION   "REV1_0"             /*  This is a string from the LPT_STANDARD_VERSION_OPTIONS array for the active LPT SPI Standard version  */
#define PARAM_SPI_HAS_CSB_PIN               1             /*  Does the part have a csb pin?  */
#define PARAM_SPI_BUS_MODE_SUPPORT          1             /*  When set to true, Bus mode is supported.  */
#define PARAM_SPI_ISOLATED_3_WIRE_SUPPORT          0             /*  Does the part support the 3-wire isolate mode of operation  */
#define PARAM_SPI_DAISY_CHAIN_MODE_SUPPORT          0             /*  When set to true, Daisy chain mode is supported.  */
#define PARAM_SPI_CHECK_GTE_1_MODE_SUPPORTED          1             /*  This is used to check that at least mode is enabled  */
#define PARAM_SPI_INTERFACE_MODE_SWITCH     "None"             /*  Valid options are 'None', 'HW' or 'SW'  */
#define PARAM_SPI_CRC_SUPPORT      "CRC_CONFIGURABLE"             /*  Set to true to enable bit fields related to CRC.  */
#define PARAM_SPI_CRC_SUPPORT_ENABLED          0             /*  Verilog output parameter for 'define  */
#define PARAM_SPI_CRC_SUPPORT_ENABLE          1             /*  Configures if CRC features are enabled in the module  */
#define PARAM_SPI_LPT_STANDARD_VERSION_VALUE          2             /*  Index value of the active LPT SPI Standard version  */
#define PARAM_SPI_ADDRESS_MODE_SUPPORT  "_15_BIT"             /*  Configures which addressing modes are supported  */
#define PARAM_SPI_ADDRESS_MODE_DEFAULT  "_15_BIT"             /*  Sets the default addressing mode  */
#define PARAM_SPI_ADDRESS_BUS_WIDTH         15             /*  Verilog output parameter for 'define  */
#define PARAM_SPI_SLOW_IFACE_CTRL_SUPPORT          0             /*  Does the part support the Slow Interface Control feature  */
#define PARAM_SPI_SOFT_RESET_0_BF_EXISTS          0             /*  Used to control if the SOFT_RESET_0 bit field exists  */
#define PARAM_SPI_SOFT_RESET_1_BF_EXISTS          0             /*  Used to control if the SOFT_RESET_1 bit field exists  */
#define PARAM_SPI_SEND_STATUS_SUPPORT "SEND_STATUS_CONFIGURABLE"             /*  Determines if and how the part supports the SEND_STATUS feature  */
#define PARAM_SPI_SEND_STATUS_SUPPORT_ENABLE          1             /*  This is used to enable various send status features  */
#define PARAM_SPI_SPI_STANDARD_VERSION_VALUE          2             /*  Value for SPI Standard VERSION bit field  */
#define PARAM_SPI_ENTITY_ACCESS_SUPPORT "ENTITY_ACCESS_ALWAYS"             /*  Configures which entity access mode(s) are supported  */
#define PARAM_SPI_ENTITY_ACCESS_SUPPORT_ENABLE          1             /*  This is used to enable/disable Strict Entity Access features  */
#define PARAM_SPI_ENTITY_ACCESS_DEFAULT          1             /*  Sets the default entity access mode  */
#define PARAM_SPI_CHIP_INDEX_EXISTS          0             /*  Used to control if the CHIP_INDEX register and related bit field exists  */
#define PARAM_SPI_OFFSET_DEV_INDEX_EXISTS          0             /*  Used to control if the OFFSET_DEV_INDEX bit field and registers exists  */
#define PARAM_SPI_DEV_INDEX_EXISTS          0             /*  Used to control if the DEV_INDEX bit field and register exists  */
#define PARAM_SPI_STATUS_BIT_0_EXISTS          0             /*  Sets EXIST for Status Bit 0  */
#define PARAM_SPI_STATUS_BIT_1_EXISTS          0             /*  Sets EXIST for Status Bit 1  */
#define PARAM_SPI_STATUS_BIT_2_EXISTS          0             /*  Sets EXIST for Status Bit 2  */
#define PARAM_SPI_STATUS_BIT_3_EXISTS          0             /*  Sets EXIST for Status Bit 3  */
#define PARAM_SPI_STATUS_BIT_0_SWNAME "Status_Bit_0"             /*  Software Name for Status Bit 0  */
#define PARAM_SPI_STATUS_BIT_1_SWNAME "Status_Bit_1"             /*  Software Name for Status Bit 1  */
#define PARAM_SPI_STATUS_BIT_2_SWNAME "Status_Bit_2"             /*  Software Name for Status Bit 2  */
#define PARAM_SPI_STATUS_BIT_3_SWNAME "Status_Bit_3"             /*  Software Name for Status Bit 3  */
#define PARAM_SPI_CHIP_TYPE           "P_ADC"             /*  This is a string that corresponds to one of the values in the CHIP_TYPE_OPTIONS array and corresponds to the type of chip being developed  */
#define PARAM_SPI_CHIP_TYPE_VALUE           7             /*  Integer value corresponding to selected CHIP_TYPE, and is used as bit field enum value  */
#define PARAM_SPI_PRODUCT_ID_VALUE         32             /*  This value is used to identify a specific generic.  */
#define PARAM_SPI_PRODUCT_ID_TRIM_BITS          4             /*  This defines the number of PRODUCT_ID bits that can be fuse/trimmed.  */

#endif  /* end ifndef _DEF_ADMW1001_REGISTERS_H */
