/*
Copyright 2019 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
 ******************************************************************************
 * @file:   admw_types.h
 * @brief:  Type definitions for ADMW API.
 *-----------------------------------------------------------------------------
 */

#ifndef __ADMW_TYPES_H__
#define __ADMW_TYPES_H__

#include "admw_platform.h"

/*!
 *****************************************************************************
 * \enum ADMW_RESULT
 *
 * ADMW API Error Codes.  #ADMW_SUCCESS is always zero
 * The return value of all ADMW APIs returning #ADMW_RESULT
 * should always be tested at the application level for success or failure.
 *
 *****************************************************************************/
typedef enum
{
    /*! Generic success.                    */
    ADMW_SUCCESS,
    /*! Generic Failure.                    */
    ADMW_FAILURE,
    /*! Operation incomplete, call again    */
    ADMW_INCOMPLETE,
    /*! Device is already initialized.      */
    ADMW_IN_USE,
    /*! Invalid device handle.              */
    ADMW_INVALID_HANDLE,
    /*! Invalid device ID.                  */
    ADMW_INVALID_DEVICE_NUM,
    /*! Device is uninitialized.            */
    ADMW_ERR_NOT_INITIALIZED,
    /*! NULL data pointer not allowed.      */
    ADMW_INVALID_POINTER,
    /*! Parameter is out of range.          */
    ADMW_INVALID_PARAM,
    /*! Unsupported mode of operation.      */
    ADMW_UNSUPPORTED_MODE,
    /*! Invalid operation                   */
    ADMW_INVALID_OPERATION,
    /*! No data available, or buffer full   */
    ADMW_NO_DATA,
    /*! No buffer space available           */
    ADMW_NO_SPACE,
    /*! Square root of a negative number    */
    ADMW_NEGATIVE_SQRT,
    /*! Division by 0 or 0.0                */
    ADMW_DIVIDE_BY_ZERO,
    /*! Invalid signature                   */
    ADMW_INVALID_SIGNATURE,
    /*! Wrong size                          */
    ADMW_WRONG_SIZE,
    /*! Sample Out of the dsp data limits   */
    ADMW_OUT_OF_RANGE,
    /*! Unable to operate with not a number */
    ADMW_NAN_FOUND,
    /*! Timeout error */
    ADMW_TIMEOUT,
    /*! Memory allocation error */
    ADMW_NO_MEM,
    /*! CRC validation error */
    ADMW_CRC_ERROR,
} ADMW_RESULT;

#endif /* __ADMW_TYPES_H__ */
