/*
Copyright 2019 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __ADMW1001_HOST_COMMS_H__
#define __ADMW1001_HOST_COMMS_H__

#include "admw_types.h"

/*
 * The host is expected to transfer a 16-bit command, followed by data bytes, in 2
 * separate transfers delineated by the CS signal and a short delay in between.
 *
 * The 16-bit command contains a right-justified 11-bit register address (offset),
 * and the remaining upper 5 bits are reserved as command bits assigned as follows:
 * [15:11] 10000b = write command, 01000b = read command, anything else is invalid
 * [10:0]  register address (0-2047)
 */

/* Register address space is limited to 2048 bytes (11 bit address) */
#define ADMW1001_HOST_COMMS_CMD_MASK 0xF800
#define ADMW1001_HOST_COMMS_ADR_MASK 0x07FF

/*
 * The following commands are currently supported, anything else is treated
 * as an error
 */
#define ADMW1001_HOST_COMMS_WRITE_CMD 0x8000
#define ADMW1001_HOST_COMMS_READ_CMD  0x4000

#define ADMW1001_HOST_COMMS_DEBUG_WRITE_CMD 0x8800
#define ADMW1001_HOST_COMMS_DEBUG_READ_CMD  0x4800

/*
 * The following bytes are sent back to the host when a command is recieved,
 * to be used by the host to verify that we were ready to receive the command.
 */
#define ADMW1001_HOST_COMMS_CMD_RESP_0 0xF0
#define ADMW1001_HOST_COMMS_CMD_RESP_1 0xE1

/*
 * The following minimum delay, in microseconds, must be inserted after each SPI
 * transfer to allow time for it to be processed by the device
 */
#define ADMW1001_HOST_COMMS_XFER_DELAY (60)

/*
 * The following defines the maximum number of retries before aborting a transfer.
 */
#define ADMW1001_HOST_COMMS_MAX_RETRIES (10)


/*! ADMW1001 Sensor Result bit field structure */
typedef struct ADMW1001_Sensor_Result_t {
    union {
        struct {
            float32_t Sensor_Result;      /**< Linearized and compensated sensor result */
            uint32_t Channel_ID    :  4;  /**< Indicates which channel this result corresponds to */
            uint32_t Ch_Error      :  1;  /**< Indicates Error on channel */
            uint32_t Ch_Alert      :  1;  /**< Indicates Alert on channel */
            uint32_t Ch_Raw        :  1;  /**< Indicates if Raw sensor data field is valid */
            uint32_t Ch_Valid      :  1;  /**< Indicates if this Result structure is valid */
            uint32_t Raw_Sample    : 24;  /**< Raw sensor data value */
        };
        uint64_t VALUE64;
   };
} ADMW1001_Sensor_Result_t;

#endif /* __ADMW1001_HOST_COMMS_H__ */
