/*
Copyright 2019 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 ******************************************************************************
 * @file:  platform.h
 * @brief: platform-specific type definitions for ADMW1001
 *-----------------------------------------------------------------------------
 */
#ifndef __PLATFORM_H__
#define __PLATFORM_H__

#include "admw_api.h"
#include "admw1001/admw1001_api.h"

#if defined (__MBED__)

#  include <mbed.h>

#  if defined(TARGET_NUCLEO_F411RE)
#    define PLATFORM_SPI_MOSI           D11
#    define PLATFORM_SPI_MISO           D12
#    define PLATFORM_SPI_SCK            D13
#    define PLATFORM_SPI_CS             D10
#    define PLATFORM_SPI_WAKEUP         D8
#    define PLATFORM_GPIO_RESET         D6
#    define PLATFORM_GPIO_ALERT_ERROR   D3
#    define PLATFORM_GPIO_DATAREADY     D4
#    define PLATFORM_LOG_TX             D1
#    define PLATFORM_LOG_RX             D0
#  elif defined(TARGET_ADUCM4050)
#    define PLATFORM_SPI_MOSI           D11
#    define PLATFORM_SPI_MISO           D12
#    define PLATFORM_SPI_SCK            D13
#    define PLATFORM_SPI_CS             D10
#    define PLATFORM_GPIO_RESET         D6
#    define PLATFORM_GPIO_ALERT_ERROR   D3
#    define PLATFORM_GPIO_DATAREADY     D5
#    define PLATFORM_LOG_TX             D0
#    define PLATFORM_LOG_RX             D1
#  else
#    error "Unknown target device"
#  endif

#  define PLATFORM_CONNECTION_INFO                  \
    {                                               \
        .type = ADMW_CONNECTION_TYPE_SPI,           \
        .spi = {                                    \
            .mosiPin    = PLATFORM_SPI_MOSI,        \
            .misoPin    = PLATFORM_SPI_MISO,        \
            .sckPin     = PLATFORM_SPI_SCK,         \
            .csPin      = PLATFORM_SPI_CS,          \
            .wakeupPin  = PLATFORM_SPI_WAKEUP,       \
            .maxSpeedHz = 2000000,                  \
        },                                          \
        .gpio = {                                   \
            .resetPin     = PLATFORM_GPIO_RESET,    \
            .alertErrorPin= PLATFORM_GPIO_ALERT_ERROR,\
            .datareadyPin = PLATFORM_GPIO_DATAREADY,\
        },                                          \
        .log = {                                    \
            .txPin        = PLATFORM_LOG_TX,        \
            .rxPin        = PLATFORM_LOG_RX,        \
            .baudRate     = 115200,                 \
            .disableLogs  = false,                  \
        } \
    }

#else
#  error "Unknown host platform"
#endif

#endif /* __PLATFORM_H__ */

