#include "admw1001/admw1001_lut_data.h"
#include "admw1001/admw1001_sensor_types.h"
#include "inc/admw_config_types.h"
/*
 * The following table provide linearisation data for a 4-wire bridge sensor
 * identified with the ADMW1001_ADC_SENSOR_BRIDGE_4WIRE_1
 * sensor type.  The Look-Up Table provided maps a range of input (X)
 * values to a corresponding range of output (Y) values.  In this example,
 * the bridge sensor input in millivolts is effectively translated to volts.
 */
ADMW1001_LUT_DESCRIPTOR bridge_4wire_1_range1_desc = {
    .geometry = ADMW1001_LUT_GEOMETRY_NES_1D,
    .channel =ADMW1001_CH_ID_ANLG_1_UNIVERSAL,
    .equation = ADMW1001_LUT_EQUATION_LUT,
    .dir = ADMW1001_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADMW1001_ADC_SENSOR_BRIDGE_4WIRE,
    .dataType = ADMW1001_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by admw_1001_AssembleLutData() */
    .crc16 = 0   /* Filled by admw_1001_AssembleLutData() */
};
ADMW1001_LUT_1D_NES bridge_4wire_1_range1_data = {
    .nElements = 2,
    .lut = {
        -0.5f, /* x(min) */
        +0.5f, /* x(max) */
        -0.5f,    /* y(min) */
        +0.5f,    /* y(max) */
    },
};

/*
 * The following variables can be passed as parameters to
 * admw_1001_AssembleLutData()
 */
ADMW1001_LUT_DESCRIPTOR *lut_desc_list[] = {
    &bridge_4wire_1_range1_desc,
};

ADMW1001_LUT_TABLE_DATA *lut_data_list[] = {
    (ADMW1001_LUT_TABLE_DATA *) &bridge_4wire_1_range1_data,
};

unsigned lut_num_tables =
    (sizeof(lut_desc_list) / sizeof(lut_desc_list[0]));

