/*
Copyright 2019, 2020 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
 ******************************************************************************
 * @file:
 * @brief:  Sensor type definitions for ADMW1001.
 *-----------------------------------------------------------------------------
 */

#ifndef __ADMW1001_SENSOR_TYPES_H__
#define __ADMW1001_SENSOR_TYPES_H__

/*! @addtogroup ADMW1001_Api
 *  @{
 */

#ifdef __cplusplus
extern "C" {
#endif

/*! ADMW1001 measurement channel identifiers */
typedef enum
{
    ADMW1001_CH_ID_NONE  = -1,
    /*!< Used to indicate when no channel is selected */

    ADMW1001_CH_ID_ANLG_1_UNIVERSAL = 0,
    /*!< Universal channel 1 universal channel */
    ADMW1001_CH_ID_ANLG_2_UNIVERSAL,
    /*!< Universal channel 2 universal channel */
    ADMW1001_CH_ID_ANLG_1_DIFFERENTIAL,
    /*!< Universal channel 1 differential channel */
    ADMW1001_CH_ID_ANLG_2_DIFFERENTIAL,
    /*!< Universal channel 2 differential channel */

    ADMW1001_CH_ID_DIG_I2C_0,
    /*!< Digital I2C Sensor channel #0 */
    ADMW1001_CH_ID_DIG_I2C_1,
    /*!< Digital I2C Sensor channel #1 */
    ADMW1001_CH_ID_DIG_I2C_2,
    /*!< Digital I2C Sensor channel #2 */
    ADMW1001_CH_ID_DIG_I2C_3,
    /*!< Digital I2C Sensor channel #3 */
    ADMW1001_CH_ID_DIG_I2C_4,
    /*!< Digital I2C Sensor channel #4 */
    ADMW1001_CH_ID_DIG_I2C_5,
    /*!< Digital I2C Sensor channel #5 */

    ADMW1001_CH_ID_DIG_SPI_0,
    /*!< Digital SPI Sensor channel #0 */
    ADMW1001_CH_ID_DIG_SPI_1,
    /*!< Digital SPI Sensor channel #1 */
    ADMW1001_CH_ID_DIG_SPI_2,
    /*!< Digital SPI Sensor channel #2 */

    ADMW1001_MAX_CHANNELS,
    /*!< Maximum number of measurement channels on ADMW1001 */

}   ADMW1001_CH_ID;

/*! ADMW1001 analog sensor type options
 *
 *  Select the sensor type that is connected to an ADC analog measurement
 *  channel.
 *
 *  @note Some channels may only support a subset of the available sensor types
 *        below.
 *
 */
typedef enum {
    ADMW1001_ADC_SENSOR_THERMOCOUPLE_T = 0,
        /*!< Standard T-type Thermocouple temperature sensor
         *
         * @note For use with Analog Sensor channels only
         */
    ADMW1001_ADC_SENSOR_THERMOCOUPLE_J = 1,
    /*!< Standard J-type Thermocouple temperature sensor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMOCOUPLE_K = 2,
    /*!< Standard K-type Thermocouple temperature sensor
     *
     * @note For use with Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_THERMOCOUPLE_E = 3,
    /*!< Standard E-type Thermocouple temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_THERMOCOUPLE_N = 4,
    /*!< Standard N-type Thermocouple temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_THERMOCOUPLE_R = 5,
    /*!< Standard R-type Thermocouple temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_THERMOCOUPLE_S = 6,
    /*!< Standard S-type Thermocouple temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_THERMOCOUPLE_B = 7,
    /*!< Standard B-type Thermocouple temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_THERMOCOUPLE_CUSTOM = 8,
    /*!< CUSTOM -type Thermocouple temperature sensor with custom
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT100 = 32,
    /*!< Standard 2-wire PT100 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT1000 = 33,
    /*!< Standard 2-wire PT1000 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT10 = 34,
    /*!< Standard 2-wire PT10 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT50 = 35,
    /*!< Standard 2-wire PT50 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT200 = 36,
    /*!< Standard 2-wire PT200 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT500 = 37,
    /*!< Standard 2-wire PT500 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_PT1000_0P00375 = 38,
    /*!< Standard 2-wire PT1000 RTD temperature sensor with alpha 0.00375
     *   linearisation
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_NI120 = 39,
    /*!< Standard 2-wire NI120 RTD temperature sensor
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_2WIRE_CUSTOM = 40,
    /*!< 2-wire Custom RTD temperature sensor with user-defined linearisation and
     *   default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT100 = 64,
    /*!< Standard 3-wire PT100 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT1000 = 65,
    /*!< Standard 3-wire PT1000 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT10 = 66,
    /*!< Standard 3-wire PT10 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT50 = 67,
    /*!< Standard 3-wire PT50 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT200 = 68,
    /*!< Standard 3-wire PT200 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT500 = 69,
    /*!< Standard 3-wire PT500 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_PT1000_0P00375 = 70,
    /*!< Standard 3-wire PT1000 RTD temperature sensor with alpha 0.00375
     *   linearisation
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_NI120 = 71,
    /*!< Standard 3-wire NI120 RTD temperature sensor
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_3WIRE_CUSTOM = 72,
    /*!< 3-wire Custom RTD temperature sensor with user-defined linearisation and
     *   default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT100 = 96,
    /*!< Standard 4-wire PT100 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT1000 = 97,
    /*!< Standard 4-wire PT1000 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT10 = 98,
    /*!< Standard 4-wire PT10 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT50 = 99,
    /*!< Standard 4-wire PT50 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT200 = 100,
    /*!< Standard 4-wire PT200 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT500 = 101,
    /*!< Standard 4-wire PT500 RTD temperature sensor with default
     *   linearisation and default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */

    ADMW1001_ADC_SENSOR_RTD_4WIRE_PT1000_0P00375 = 102,
    /*!< Standard 4-wire PT1000 RTD temperature sensor with alpha 0.00375
     *   linearisation
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_NI120 = 103,
    /*!< Standard 4-wire NI120 RTD temperature sensor
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_RTD_4WIRE_CUSTOM = 104,
    /*!< 4-wire Custom RTD temperature sensor with user-defined linearisation and
     *   default configuration options
     *
     * @note For use with Cold-Juction Compensation and Analog Sensor channels
     *       only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_44004_44033_2P252K_AT_25C = 128,
    /*!< Standard 2.252kOhm NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_44005_44030_3K_AT_25C = 129,
    /*!< Standard 3kOhm NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_44007_44034_5K_AT_25C = 130,
    /*!< Standard 5kOhm NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_44006_44031_10K_AT_25C = 131,
    /*!< Standard 10kOhm NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_44008_44032_30K_AT_25C = 132,
    /*!< Standard 30kOhm NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_YSI_400 = 133,
    /*!< Standard YSI400 NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_SPECTRUM_1003K_1K = 134,
    /*!< Standard 1kOhm NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_CUSTOM_STEINHART_HART = 135,
    /*!< CUSTOM Equation NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_THERMISTOR_CUSTOM_TABLE = 136,
    /*!< Custom Table NTC Thermistor
     *
     * @note For use with Analog Sensor channels only
     */
    ADMW1001_ADC_SENSOR_BRIDGE_4WIRE = 168,
    /*!< Standard 4-wire Bridge Transducer sensor with user-defined
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     * @note Bridge Excitation Voltage must be selected as reference
     */
    ADMW1001_ADC_SENSOR_BRIDGE_6WIRE = 200,
    /*!< Standard 6-wire Bridge Transducer sensor with user-defined
     *   linearisation and default configuration options
     *
     * @note For use with Analog Sensor channels only
     * @note Bridge Excition Voltage must be selected as reference
     */
    ADMW1001_ADC_SENSOR_DIODE = 224,
    /*!< Standard Diode current temperature sensor
     *
     * @note For use with  Analog Sensor channels only
     */
     ADMW1001_ADC_SENSOR_SINGLE_ENDED_ABSOLUTE = 576,
    /*!< Test sensor for internal use
     *
     * @note For use with Analog 4-20mA Current Sensor channels only
     */
     ADMW1001_ADC_SENSOR_DIFFERENTIAL_ABSOLUTE = 640,
    /*!< Test sensor for internal use
     *
     * @note For use with Analog 4-20mA Current Sensor channels only
     */
     ADMW1001_ADC_SENSOR_SINGLE_ENDED_RATIO = 656,
    /*!< Test sensor for internal use
     *
     * @note For use with Analog 4-20mA Current Sensor channels only
     */
     ADMW1001_ADC_SENSOR_DIFFERENTIAL_RATIO = 672,
    /*!< Test sensor for internal use
     *
     * @note For use with Analog 4-20mA Current Sensor channels only
     */

}   ADMW1001_ADC_SENSOR_TYPE;

/*! ADMW1001 I2C digital sensor type options
 *
 *  Select the sensor type that is connected to an I2C digital measurement
 *  channel.
 *
 *  @note These are pre-defined sensors using built-in linearisation data
 */
typedef enum
{

    ADMW1001_I2C_SENSOR_HUMIDITY = 2112,
    /*!< Sensirion SHT35-DIS-B humidity sensor
     *
     * @note For use with I2C Digital Sensor channels only
     */
     ADMW1001_I2C_SENSOR_TEMPERATURE_ADT742X = 2218,
    /*!< ADT742X sensor
     *   Note: the ADT742X Temperature sensor.
     *
     * @note For use with I2C Digital Sensor channels only
     */
} ADMW1001_I2C_SENSOR_TYPE;

/*! ADMW1001 SPI digital sensor type options
 *
 *  Select the sensor type that is connected to an SPI digital measurement
 *  channel.
 *
 *  @note These are pre-defined sensors using built-in linearisation data
 */
typedef enum
{
    ADMW1001_SPI_SENSOR,
}   ADMW1001_SPI_SENSOR_TYPE;

#ifdef __cplusplus
}
#endif

/*!
 * @}
 */

#endif /* __ADMW1001_SENSOR_TYPES_H__ */
