/*
Copyright 2019 (c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights
    of one or more patent holders. This license does not release you
    from the requirement that you obtain separate licenses from these
    patent holders to use this software.
  - Use of the software either in source or binary form, must be run
    on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

/*!
 ******************************************************************************
 * @file:
 * @brief:
 *-----------------------------------------------------------------------------
 */
#include "admw_config_types.h"

ADMW_CONFIG rtd_4w_config = {
    .versionId = { .major = 2, .minor = 0 },
    .productId = ADMW_PRODUCT_ID_ADMW1001,
    .admw1001 = {
        .power = {
            .powerMode = ADMW1001_POWER_MODE_ACTIVE,
        },
        .measurement = {
            .externalRefVoltage=0.0,
            .AVDDVoltage=3.0,
            .operatingMode = ADMW1001_OPERATING_MODE_CONTINUOUS,
            .dataReadyMode = ADMW1001_DATAREADY_PER_CYCLE,
            .cycleInterval = 0,
            .excitationState = ADMW1001_ADC_EXC_STATE_CYCLE_POWER,
            .vBiasEnable = false,
            .RSenseValue = 1000,
            .groundSwitch = ADMW1001_ADC_GND_SW_OPEN,
            .fifoNumCycles = 1,
        },
        .channels = {
            [ADMW1001_CH_ID_ANLG_1_UNIVERSAL] = {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADMW1001_CH_ID_NONE,
                .lutSelect = ADMW1001_LUT_DEFAULT,
                .measurementUnit = ADMW1001_MEASUREMENT_UNIT_CELSIUS,
                .extraSettlingTime = 4.49999986449257,
                .lowThreshold = -50,
                .highThreshold = 250,
                .measurementsPerCycle = 1,
                .offsetAdjustment = 0,
                .gainAdjustment = 1,
                .adcChannelConfig = {
                    .sensor = ADMW1001_ADC_SENSOR_RTD_4WIRE_PT100,
                    .gain = ADMW1001_ADC_GAIN_1X,
                    .current = {
                        .outputLevel = ADMW1001_ADC_EXC_CURRENT_500uA,
                    },
                    .rtdCurve = ADMW1001_ADC_RTD_CURVE_EUROPEAN,
                    .filter = {
                        .type = ADMW1001_ADC_FILTER_SINC3,
                        .sf = ADMW1001_SF_8P24HZ,
                        .chopMode = ADMW1001_CHOP_MD_SW,
                        .notch1p2 = true
                    },
                    .reference = ADMW1001_ADC_REFERENCE_VOLTAGE_INTERNAL,
                    .bufferBypass = ADMW1001_BUFFER_BYPASSS_DISABLED,
                },
            },
        },
    },
};