/* mbed Library - Sparkfun breakboard LCD 11062
 * This is using the Philips PCF8833 controller
 */

#ifndef MBED_LCD_11062_H
#define MBED_LCD_11062_H

//Colours in RGB 8:8:8 on the 24 bit mode (will be convert to 5:6:5 16bit mode)
#define BLACK   0x000000
#define GRAY    0xC2C2C2
#define WHITE   0xFFFFFF
#define RED     0xFF0000
#define GREEN   0x008000
#define LIME    0x00FF00
#define BLUE    0x0000FF
#define AQUA    0x00FFFF
#define FUCHSIA 0xFF00FF
#define PURPLE  0x912CEE
#define YELLOW  0xFFFF00
#define BROWN   0x87421F
#define ORANGE  0xFF8000

#include "mbed.h"

namespace mbed {
    /* Class: LCD_11062
     * An abstraction of the 130x130 Nokia Mobile LCD display
     * which is used on the Sparkfun breakboard LCD 11062
     *
     * Example:
     * >
     * > #include "mbed.h"
     * > #include "LCD_11062.h"
     * >
     * > LCD_11062 lcd(p5,p7,p6,p8);
     * >
     * > int main() {
     * >     lcd.printf("Hello World!");
     * > }
     */
    
    class LCD_11062 : public Stream {
        public:
        /* Constructor: LCD_11062
         *  Create and object for the Mobile LCD, using SPI and two DigitalOuts
         *
         * Variables:
         *  mosi - SPI data out (miso is not used)
         *  clk  - SPI clock
         *  cs   - Chip Select
         *  rst  - reset
         */
        LCD_11062(PinName mosi, PinName clk, PinName cs, PinName rst);
        virtual void reset();
        virtual void _select();
        virtual void _deselect();
        virtual void _window(int x, int y, int width, int height);
        virtual void _putp(int colour);
        void command(int value);
        void data(int value);
        void foreground(int v);
        void background(int v);
        void locate(int column, int row);
        void newline();
        virtual int _putc(int c);
        virtual int _getc() {return 0; }
        SPI _spi;
        DigitalOut _rst;
        DigitalOut _cs;
        void bitblit(int x, int y, int width, int height, const char* bitstream);
        void fill(int x, int y, int width, int height, int colour);
        void blit(int x, int y, int width, int height, const int* colour);
        void cls();
        int width();
        int height();
        int columns();
        int rows();
        void putp(int v);
        void window(int x, int y, int width, int height);
        void pixel(int x, int y, int colour);
        int _row, _column, _rows, _columns, _foreground, _background, _width, _height, _spifreq, charwidth, charheight;
    };

}

#endif