/**
 * @section LICENSE
 *
 * Copyright (c) 2010 Christian Zagel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @section DESCRIPTION
 *
 * YGE25i Regler
 *
 */

/**
 * Includes
 */
#include "YGE25i.h"

YGE25i::YGE25i(PinName sda, PinName scl,int adress_) : i2c_(sda, scl){

    //200kHz, normal mode.
    i2c_.frequency(200000);
    adress=adress_;
    //save_.attach_us(this,&YGE25i::YGESetPWMSave,1000);
    for(int a=0;a<=40;a++){
    
    wait_ms(10);
    YGESetPWM(0);
    
    } 
    wait(0.4); 
}

char YGE25i::YGEReadReg(char reg){

    char rx;
    reg=reg|0x80;
    int ack=1;
    ack=i2c_.write(adress & 0xFE, &reg, 1);
    if(ack!=0){return 255;}
    ack=i2c_.read(adress | 0x01, &rx, 1);
    if(ack!=0){return 255;}
    return rx;

}

int YGE25i::YGEWriteReg(char reg, char data){

    char tx[2];
    int ack=1; 
    tx[0] = reg|0x80;
    tx[1] = data;
    
    ack=i2c_.write(adress & 0xFE, tx, 2);
    if(ack!=0){return 255;}
    else 
    return 0;
    
}


int YGE25i::YGESetPWM( char pwm_){

    pwm=pwm_;
    char tx;
    tx=pwm_ & 0x7f;
    int ack;    
    ack=i2c_.write(adress & 0xFE, &tx, 1);
    if(ack!=0){return 255;}
    else
    return 0;

}  

void YGE25i::setAdress(int adress_){

    adress=adress_;
}

 
void YGE25i::YGESetPWMSave(void){
    char tx;
    tx=pwm & 0x7f;   
    i2c_.write(adress & 0xFE, &tx, 1);
}  
   
void YGE25i::setPWM(int pwm_){
    
    pwm=pwm_;
}  