/**
 * @section LICENSE
 *
 * Copyright (c) 2010 Christian Zagel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @section DESCRIPTION
 *
 * YGE25i Regler
 */


#ifndef MOTORCONTROL_H
#define MOTORCONTROL_H

/**
 * Includes
 */
#include "mbed.h"

/**
 * Defines
 */
//Registers.

#define rpmByte0    0x00
#define rpmByte1    0x01
#define rpmByte2    0x02
#define voltage     0x03
#define current     0x04
#define temperature 0x05
#define lastError   0x06
#define i2cSlaveAdr 0x07    
#define DefaultAdr  0x88

/**
 * YGE25i
 */
class YGE25i
{
    private:

        I2C i2c_;
        int throttle;
        char adress;
           
    public:
    
        /**
        * Constructor.
        *
        * Sets I2C SDA/SCL and Slave Adress
        *
        * @param sda - mbed pin to use for the SDA I2C line.
        * @param scl - mbed pin to use for the SCL I2C line.
        * @param adress_ - Slave Adress
        */
        YGE25i(PinName sda, PinName scl,char adress_);
        /**
        * Read Register
        *
        * @return The contents of the register reg.  If 255 Error!!!       
        */
        char YGEReadReg(char reg);
        /**
        * Write to a register
        *
        * @return Acknowledge: If 255 Error
        *         
        */
        void YGEWriteReg( char reg, char data);
        /**
        * Set PWM
        *
        * @return Acknowledge: If 255 Error
        *         
        */
        void YGESetPWM( int pwm_);
              
        /**
        * Set Adress
        *
        * @return void
        *         
        */
        
        void setAdress(char adress_);
            
            
        void initMotor(void);
        
};

#endif
        
        
        
        
        