/**
 * @section LICENSE
 *
 * Copyright (c) 2010 Christian Zagel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @section DESCRIPTION
 *
 * YGE25i Regler
 *
 */

/**
 * Includes
 */
#include "MotorControl.h"

YGE25i::YGE25i(PinName sda, PinName scl,char adress_) : i2c_(sda, scl){

    //400kHz, fast mode.
    i2c_.frequency(400000);
    adress=adress_;
}

char YGE25i::YGEReadReg(char reg){

    char rx;
    reg=reg|0x80;
    i2c_.write(adress & 0xFE, &reg, 1);
    i2c_.read(adress | 0x01, &rx, 1);
    return rx;

}

void YGE25i::YGEWriteReg(char reg, char data){

    char tx[2]; 
    tx[0] = reg|0x80;
    tx[1] = data;
    i2c_.write(adress & 0xFE, tx, 2);  
}


void YGE25i::YGESetPWM(int pwm_){

    throttle=pwm_;
    char tx;
    tx=pwm_ & 0x7f;
    i2c_.write(adress & 0xFE, &tx, 1);
}  

void YGE25i::setAdress(char adress_){
    
    YGEWriteReg(0x07,adress_);
    adress=adress_;
}

 

void YGE25i::initMotor(void){
    
    int a = 0;
    while(a<40){
    
        wait_ms(10);
        YGESetPWM(0);
        a++;
    } 
}
    