#include "mbed.h"
#include "include/menbedRefresher.h"
#include "include/menbedNavigator.h"

MenbedRefresher::MenbedRefresher (MenbedNavigator *navigator) :
    navigator(navigator), refreshPeriod_us(50000)
{
    ticker.attach_us (navigator, &MenbedNavigator::updateDisplay, refreshPeriod_us);
}

MenbedRefresher::MenbedRefresher (MenbedNavigator *navigator, uint32_t refreshPeriod_us) :
    navigator(navigator), refreshPeriod_us(refreshPeriod_us)
{
    ticker.attach_us (navigator, &MenbedNavigator::updateDisplay, refreshPeriod_us);
}

void MenbedRefresher::refreshed (void)
{
    // Detatch and then re-attached the ticker to reset it
    ticker.detach();
    ticker.attach_us (navigator, &MenbedNavigator::updateDisplay, refreshPeriod_us);
}