#ifndef _MENBED_H_
#define _MENBED_H_

#include "menbedButtonEvent.h"
#include "menbedButtonHandler.h"
#include "menbedButtonHandlerTimespec.h"
#include "menbedNavigator.h"
#include "menbedMenu.h"
#include "menbedMenuItem.h"
#include "menbedRefresher.h"

#include "../displays/include/menbedDisplayHD44780.h"


class Menbed {
public:
    Menbed (PinName select, PinName down, PinName up, PinName cancel,
        MenbedMenu *rootMenu,
        MenbedDisplay *display);
        
    Menbed (PinName select, PinName down, PinName up,
        MenbedMenu *rootMenu,
        MenbedDisplay *display);
        
    Menbed (PinName select, PinName down,
        MenbedMenu *rootMenu,
        MenbedDisplay *display);                

    Menbed (PinName select, PinName down, PinName up, PinName cancel, 
        MenbedButtonHandlerTimespec *timespec,
        MenbedMenu *rootMenu,
        MenbedDisplay *display);

    ~Menbed ();
protected:
    MenbedButtonHandler *buttonHandler;
    MenbedNavigator *navigator;
    MenbedDisplayer *displayer;
    MenbedRefresher *refresher;
};

#endif /* _MENBED_H_ */