#include "mbed.h"
#include "menbed.h"
#include "TextLCD.h"
#include "Adafruit_ST7735.h"

Serial pc(USBTX, USBRX);
DigitalIn enable(D2);
//float photocellVoltage(void) {return 0;}

Adafruit_ST7735 tft(D11, D12, D13, D10, D8, D9); // MOSI, MISO, SCLK, SSEL, TFT_DC, TFT_RST

void testlines(uint16_t color);
void testfastlines(uint16_t color1, uint16_t color2);
void IniciandoMaquina(void);
void Alerta(void);
void MenuPrincipal(void);
void Aguarde(void);
void Executando(void);

//Serial pc(USBTX, USBRX); // tx, rx
//I2C i2c_lcd(D14,D15); // SDA, SCL
//TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD20x4);                  // I2C exp: I2C bus, PCF8574 Slaveaddress, LCD Type

int main() {
    
    // Use this initializer if you're using a 1.8" TFT
    tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab

    //iniciando máquina
    IniciandoMaquina();
    wait_ms(5000);
    Alerta();
    wait_ms(5000);
    MenuPrincipal();
    wait_ms(5000);
    Aguarde();
    wait_ms(5000);
    Executando();
    wait_ms(5000);
    //InicioProcessoReferenciamento();
    //wait_ms(5000);
    

//lcd.setBacklight(TextLCD::LightOn);

    // Declare all the submenus so that they can be referenced in the
    // definitions of other menus
    MenbedMenu *rootMenu;
    MenbedMenu *measurementMenu;
    MenbedMenu *controlMenu;
    MenbedMenu *aboutMenu;

    // Root menu--to create a menu, we first create an array of pointers to 
    // all the menu items that will populate the menu.  The MenbedMenuItem
    // constructor take five arguments: the function to be executed when the
    // item is selected; the child menu to open when the item is selected;
    // a boolean indicating whether the child menu is actually this menu's
    // ancestor, (useful when creating "go to root menu" items); a parameter
    // object that holds a value to be viewed or modified; and a text string
    // indicating what the menu item should say.  The text string may contain
    // a printf-style specifier for a float that is bracketed by \t characters
    // to offset it from the surrounding text.  If the float specified is
    // found, it will be replaced by the value of the parameter.
    MenbedMenuItem *rootMenuItems[5] = {
        new MenbedMenuItem (NULL, &measurementMenu, false, NULL, "Controle Manual"), // function,child,bollean,data,text
        new MenbedMenuItem (NULL, &controlMenu, false, NULL, "Arquivos"),
        new MenbedMenuItem (NULL, &aboutMenu, false, NULL, "Configuracoes"),
        new MenbedMenuItem (NULL, &rootMenu, false, NULL, "Referenciamento"),
        new MenbedMenuItem (NULL, &rootMenu, false, NULL, "Capacitivo"),
    };
    // After we have the array of pointers to menu items, we pass the number of
    // elements in the arry and the array itself to the MenbedMenu constructor.
    rootMenu = new MenbedMenu (5, rootMenuItems);

    // Measurements menu--the first item of the measurement menu displays the
    // voltage and the resistor divider junction formed between a photocell and
    // a fixed resistor.  To print this voltage as part of a menu item, we
    // create a MenbedMenuParam object that takes as arguments to its
    // constructor: a pointer to a function that returns a float containing the
    // value of the parameter; a pointer to a function that we would call to 
    // change the value of the parameter; a boolean (irrevelant here)
    // indicating whether the parameter, if it were modifiable by the user, 
    // should be updated as the user is changing its value or whether its
    // should only be updated after the user has confirmed the new value; a 
    // minimum value for the parameter; a maximum value; and a step size.
       //MenbedMenuParam photocellParam (photocellVoltage, NULL, false, 0.0, 0.0, 0.0);
       
    // Having created the parameter, we pass it as the 4th argument of the 
    // MenbedMenuItem constructor.  Note the \t-offset %.2f format specified
    // in the menu item text.  The menu system will call the photocellVoltage
    // function specified in the parameter constructor above and then print the
    // float that it returns in place of the %.2f in the menu text.

    MenbedMenuItem *measurementMenuItems[2] = {
        //new MenbedMenuItem (NULL, NULL, false, &photocellParam, "Photocell: \t%.2f\tV"),
        new MenbedMenuItem (NULL, &rootMenu, true, NULL, "lee") };
    measurementMenu = new MenbedMenu (2, measurementMenuItems);

    // Controls menu--We have modifiable parameters in the first and second
    // meu items of the controls menu.  Walking through the first parameter
    // constructor, the getLed1Pwm function pointer points to a function that
    // returns the current value of the PWM duty cycle.  The setLed1Pwm 
    // function pointer points to a function which sets the PWM duty cycle.
    // The boolean set to true indicates that as soon as the user makes a 
    // change to the parameter, the setLed1Pwm function will be called.  The
    // menu system will not wait for the user to confirm his change before
    // making the call.  The 0.0 and 100.0 represent the minimum and 
    // maximum PWM values.  The final 1.0 paramter is the step size when
    // changing the PWM duty cycle.
 //   MenbedMenuParam pwmParam1 (getLed1Pwm, setLed1Pwm, true, 0.0, 100.0, 1.0);
    // The only different in this parameter from the one above is that the PWM
    // duty cycle is not updated (setLed2Pwm is not called) until the user
    // confirms the new duty cycle.  If the user cancels his modifications
    // (either by pushing the cancel button or pushing and holding the select
    // button) setLed2PWM is never called.
   // MenbedMenuParam pwmParam2 (getLed2Pwm, setLed2Pwm, false, 0.0, 100.0, 1.0);
    // The third, fourth, and fifth items of the control menu demonstrate
    // functions when a menu item is selected.  The ability to call a function
    // can be combined with either displaying a submenu or editing a parameter.
    MenbedMenuItem *controlMenuItems[6] = {
      //  new MenbedMenuItem (NULL, NULL, false, &pwmParam1, "LED1 PWM: \t%.0f\t%"),
      //  new MenbedMenuItem (NULL, NULL, false, &pwmParam2, "LED2 PWM: \t%.0f\t%"),
      //  new MenbedMenuItem (toggleLed3, NULL, false, NULL, "Toggle LED3"),
       // new MenbedMenuItem (lightLed4, NULL, false, NULL, "Light LED4"),
       // new MenbedMenuItem (extinguishLed4, NULL, false, NULL, "Extinguish LED4"),
        new MenbedMenuItem (NULL, &rootMenu, true, NULL, "Home") };
    controlMenu = new MenbedMenu (6, controlMenuItems);       

    // About menu--there's nothing fancy here, but the lack of a "Home" item
    // forces the user to employ the cancel button, either directly or by
    // pushing and hold the select button, to return to the root menu.
    MenbedMenuItem *aboutMenuItems[3] = {
        new MenbedMenuItem (NULL, NULL, false, NULL, "     NXP3915"),
        new MenbedMenuItem (NULL, NULL, false, NULL, "  Copyright 2011"),
        new MenbedMenuItem (NULL, NULL, false, NULL, " xxxxxxxx@xxx.xxx") };
    aboutMenu = new MenbedMenu (3, aboutMenuItems);
            
    // Having created the menus, menu items, and item parameters, we are ready
    // to instantiate the display.  MenbedDisplayHD44780 extends MenbedDisplay
    // and implements the all-important writeLine function allong with some
    // other less important functions.  The pins we pass to the constructor
    // specify the physical interface connection to the LCD.
    MenbedDisplayHD44780 *hd44780Lcd = new MenbedDisplayHD44780 
        (D8, D9, D4, D5, D6, D7, MenbedDisplayHD44780::LCD20x4);

    // Now, we have the menu objects and the display object.  All we have to do
    // is create the menbed menu system.  The number of buttons used by the
    // menu system is specified by the number of pins passed to the Menbed 
    // constructor.  The pin order is select, down, up, cancel.  With 
    // constructor overloading, we can opt out of using the cancel and up
    // buttons.

    /* Four buttons (select, down, up, cancel ) */    
    Menbed menbed(D10, D11, D12, D13,
        rootMenu,
        hd44780Lcd);
}

void testlines(uint16_t color)
{
    tft.fillScreen(ST7735_BLACK);
    for (int16_t x=0; x < tft.width(); x+=6) {
        tft.drawLine(0, 0, x, tft.height()-1, color);
    }
    for (int16_t y=0; y < tft.height(); y+=6) {
        tft.drawLine(0, 0, tft.width()-1, y, color);
    }

    tft.fillScreen(ST7735_BLACK);
    for (int16_t x=0; x < tft.width(); x+=6) {
        tft.drawLine(tft.width()-1, 0, x, tft.height()-1, color);
    }
    for (int16_t y=0; y < tft.height(); y+=6) {
        tft.drawLine(tft.width()-1, 0, 0, y, color);
    }

    tft.fillScreen(ST7735_BLACK);
    for (int16_t x=0; x < tft.width(); x+=6) {
        tft.drawLine(0, tft.height()-1, x, 0, color);
    }
    for (int16_t y=0; y < tft.height(); y+=6) {
        tft.drawLine(0, tft.height()-1, tft.width()-1, y, color);
    }

    tft.fillScreen(ST7735_BLACK);
    for (int16_t x=0; x < tft.width(); x+=6) {
        tft.drawLine(tft.width()-1, tft.height()-1, x, 0, color);
    }
    for (int16_t y=0; y < tft.height(); y+=6) {
        tft.drawLine(tft.width()-1, tft.height()-1, 0, y, color);
    }
}

void testfastlines(uint16_t color1, uint16_t color2)
{
    tft.fillScreen(ST7735_BLACK);
    for (int16_t y=0; y < tft.height(); y+=5) {
        tft.drawFastHLine(0, y, tft.width(), color1);
    }
    for (int16_t x=0; x < tft.width(); x+=5) {
        tft.drawFastVLine(x, 0, tft.height(), color2);
    }
}



void IniciandoMaquina()
{
    tft.setTextWrap(true);
    tft.fillScreen(ST7735_BLACK);
    int x = 0;
    while(x < 5) {
        tft.fillScreen(ST7735_BLACK);
        tft.setCursor(0,50);
        tft.setTextColor(ST7735_WHITE);
        tft.setTextSize(2);
        tft.printf("Iniciando Pet-Finder");
        tft.setCursor(0,100);
        tft.printf("Aguarde");
        wait_ms(100);
        tft.fillScreen(ST7735_BLACK);
        tft.setCursor(0,50);
        tft.setTextColor(ST7735_WHITE);
        tft.setTextSize(2);
        tft.printf("Iniciando Pet-Finder");
        tft.setCursor(0,100);
        tft.printf("Aguarde...");
        wait_ms(100);
        x += 1;
    }
}



void Alerta() {
    tft.setTextWrap(true);
    int x = 0;
    while(x < 10) {
        tft.fillScreen(ST7735_BLACK);
        tft.setCursor(0,50);
        tft.setTextColor(ST7735_WHITE);
        tft.setTextSize(2);
        tft.printf("!!ALERTA!!");
        wait_ms(200);
        tft.fillScreen(ST7735_RED);
        tft.setTextSize(2);
        tft.printf("!!ALERTA!!");
        wait_ms(300);
        x += 1;
    }
    
}

void MenuPrincipal() {
    tft.fillScreen(ST7735_BLACK);  
    tft.setCursor(0,0);
    tft.setTextColor(ST7735_WHITE);
    tft.setTextSize(2);
    tft.printf("Pet-Finder");
    tft.setCursor(0,40);
    tft.printf("Data:");
    tft.setCursor(0,55);
    tft.printf("15/05/2017");
    tft.setCursor(0,80);
    tft.printf("Horario:");
    tft.setCursor(0,95);
    tft.printf("17h27");
    wait_ms(200);
    
    }

void Aguarde() {
    int x = 0;
    while(x < 5) {
        tft.fillScreen(ST7735_BLACK);  
        tft.setCursor(0,70);
        tft.setTextSize(2);
        tft.printf("Aguarde...");
        wait_ms(800);
        x += 1;
    }
}
    
void Executando() {
    int x = 0;
    tft.fillScreen(ST7735_WHITE);  
    tft.setTextColor(ST7735_BLACK);
    while(x < 3) {
        tft.fillScreen(ST7735_GREEN);  
        tft.setCursor(0,70);
        tft.setTextSize(2);
        tft.printf("Executando");
        wait_ms(800);
        tft.fillScreen(ST7735_WHITE);  
        tft.setTextColor(ST7735_BLACK);
        tft.setCursor(0,70);
        tft.printf("Executando");
        wait_ms(400);
        x += 1;
    
        }
    tft.fillScreen(ST7735_GREEN);  
    tft.setCursor(0,70);
    tft.printf("Executando");
}


// ----------------------------------------------------------------------------------------------------------------



