#include "mbed.h"
#include "mbedWSEsbc.h"
#define PI (3.14159)

// Declare objects (if necessary)
Ticker Controller; // declare Ticker object named "Controller"
DigitalOut myled(LED1); // LED, flash lights for debugging


// variables for data handling and storage
float TotalTime;        // Total run time
float Time;             // Current elapsed time
float Ts = 0.0083;      // Control update period (seconds) (120 Hz equivalent)
float Tstrm = 0.01;     // Data streaming period (seconds) (100 Hz equivalent)
float ang,angp,speed;   // variables for approximating speed from encoder measurements
float DCAmp;            // duty cycle applied to motor
float dc;               // duty cycle
long enc1;              // encoder variable
float lowDC;


// Function definition Prototypes (declarations)
void twoStepCode(); // declare that a separate (other than main) function named "ctrCode" exists

// Enter main function
int main ()
{
    // Initializes mbed to access functionality of encoder, A/D, driver, etc. chipsets
    // Input is baud rate for PC communication
    mbedWSEsbcInit(115200); // also initializes timer object t
    mot_en1.period(0.020); // sets PWM period to 0.02 seconds for best DC motor operation

    while(1) {
        // Scan serial port for user input to begin experiment
        pc.scanf("%f,%f",&TotalTime,&lowDC); //&DCAmp,&lowDC);
        // perform necessary functions to time the experiment
        Time = 0.0; // reset time variable
        t.reset(); // reset timer object
        // Attach the ctrCode function to ticker object specified with period Ts
        Controller.attach(&twoStepCode,Ts);
        t.start(); // start measuring elapsed time
        // perform operations while the elapsed time is less than the desired total time
        while(Time <= TotalTime) {
            // send data over serial port
            pc.printf("%f,%f,%f\n",Time,speed,dc);
            wait(Tstrm); // print data at approximately 50 Hz
        } // end while(Time<=Ttime)
        Controller.detach(); // detach ticker to turn off controller
        // Turn motor off at end of experiment
        mot_control(1,0.0);
    }// end while(1)
}// end main
// Additional function definitions
void twoStepCode() // function to attach to ticker
{
    myled = !myled; // toggle LED 2 to indicate control update
    // read current elapsed time
    Time = t.read();
    // Read encoder
    enc1 = LS7366_read_counter(1); // input is the encoder channel
    // Convert from counts to radians
    ang = 2.0*PI*enc1/6400.0;
    // Estimate speed
    speed = (ang-angp)/Ts;
    // Age variables
    angp = ang;
    // compute duty cycle for motor (will be changed later!)
    //dc = DCAmp*sin(2.0*PI/5.0*Time); // user-specified duty cycle
    // Lab3 DC
    if(Time<0.1) {
        dc = 0.0;
    } else if(Time<0.55) {
        dc = lowDC;
    } else {
        dc = 0.10;
    } 
    // motor control
    mot_control(1,dc); // first input is the motor channel, second is duty cycle
} // end ctrCode()