#include "ITG3200.h"
#include "ADXL345_I2C.h"

//Serial pc(USBTX, USBRX);
Serial rn42(p9, p10); 

ITG3200 gyro(p28, p27);
ADXL345_I2C accel(p28, p27);

int main() {
    char str[296];
    rn42.baud(115200);
    gyro.setWhoAmI(0x68);
    //pc.printf("Now starting 6-degrees-of-freedom (ITG-3200 ADXL345) test...\n");
    //pc.printf("Accelerometer Device ID is: 0x%02x\n", accel.getDeviceID());
    //pc.printf("Gyro Devide ID is: 0x%02x\n", gyro.getWhoAmI());
     
     
    short int accel_read[3] = {0, 0, 0};
    
    // Accel setup
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accel.setPowerControl(0x00)){
         rn42.printf("didn't intitialize power control\n"); 
         return 0;  }
    //Full resolution, +/-16g, 4mg/LSB.
    //wait(.001);
     
    //if(accel.setDataFormatControl(0x0B)){
      //  rn42.printf("didn't set data format\n");
      //  return 0;  }
    //wait(.001);
    
    //3.2kHz data rate.
    //if(accel.setDataRate(ADXL345_3200HZ)){
      // rn42.printf("didn't set data rate\n");
      // return 0;    }
    //wait(.001);
     
    //Measurement mode.
    
    //if(accel.setPowerControl(MeasurementMode)) {
      // rn42.printf("didn't set the power control to measurement\n"); 
      // return 0;   
    //}
     
    // Gyro setup   
    gyro.setLpBandwidth(LPFBW_256HZ);

    while (1)
    {
        //wait(0.1);
        
        accel.getOutput(accel_read);
        
        /*sprintf(str, "%i,%i,%i,%i,%i,%i,%i,A", (int16_t)accel_read[0], (int16_t)accel_read[1], (int16_t)accel_read[2],
                                                     gyro.getGyroX(), gyro.getGyroY(), gyro.getGyroZ(), (int16_t)gyro.getTemperature());*/  
                                                     
        sprintf(str, "%i,%i,%i,%i,%i,%iA", (int16_t)accel_read[0], (int16_t)accel_read[1], (int16_t)accel_read[2],
                                                     gyro.getGyroX(), gyro.getGyroY(), gyro.getGyroZ());
        rn42.printf(str);
        
        /*
        pc.printf("Gyro[%5i, %5i, %5i]   Accel[%4i, %4i, %4i]\n\t", 
                            gyro.getGyroX(), gyro.getGyroY(), gyro.getGyroZ(),
                            (int16_t)accel_read[0], (int16_t)accel_read[1], (int16_t)accel_read[2]);
        */
    }
    
}
