/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "SerialGPS.h"
#include "math.h"

#ifndef M_PI
   #define M_PI 3.14159265358979323846
#endif

//Various interruption process
Ticker toggler;            // periodic interrupt routines
//Timer debounce;             // define debounce timer

/** On many platforms USBTX/USBRX overlap with serial on D1/D0 pins and enabling the below will interrupt the communication.
 *  You can use an LCD display to print the values or store them on an SD card etc.
 */
Serial pc(USBTX, USBRX);

/**
 * PC_10 - TX pin (RX on the GPS module side)
 * PC_11 - RX pin (TX on the GPS module side)
 * 9600 - GPS baud rate
 */
SerialGPS gps(PC_10, PC_11, 9600);

void toggle_gps(){
    int i=0;
    while(1){
        //pc.printf("gps.sample?\n\r");
        if (gps.sample()) {
            i++;
            //pc.printf("true\n\r");
            pc.printf("sats %d, lat %f, lont %f, alt %f, geoid %f, time %f\n\r", gps.sats, gps.latitude, gps.longitude, gps.alt, gps.geoid, gps.time);
            break;
        }
    }
    
}

float DegToRad(float valDeg){
    return M_PI*valDeg/180;
}

double distance(float rxLat, float rxLong){
    double a=0, c=0;
    int R=6371000;
    
    double deltaLong=abs(DegToRad(rxLong)-DegToRad(gps.longitude));
    double deltaLat=abs(DegToRad(rxLat)-DegToRad(gps.latitude));
    
    a=sin(deltaLat/2)*sin(deltaLat/2)+cos((double)DegToRad(rxLat))*cos((double)DegToRad(gps.latitude))*sin(deltaLong/2)*sin(deltaLong/2);
    c=2*atan2(sqrt(a), sqrt(1-a));
    
    return R*c;
    }

int main() {
    /*
    int i=0,k;
    double distance;
    float sleep=20.0;
    toggler.attach(&toggle_gps,sleep);
    */
    gps.latitude=43.615659;
    gps.longitude=7.072609;
    pc.printf("La distance entre les deux points est de: %f", distance(43.616541,7.070429));
    while(1);
   
}