#include "mbed.h"

#define THERMISTORNOMINAL 100
#define TEMPERATURENOMINAL 25
#define NUMSAMPLES 10
#define BCOEFFICIENT 3960
#define SERIESRESISTOR 10000

Serial pc(USBTX, USBRX);

DigitalOut control1(D3);
DigitalOut control2(D4);
DigitalOut control3(D5);
DigitalOut control4(D6); 
DigitalOut control5(D7);
AnalogIn thermistor(A0);


int samples[NUMSAMPLES];

double sensorReadings[32];


void procesamientoDatos(int count){
uint8_t i;
float average;
for (; count < 8; count++){
    for(i = 0; i < NUMSAMPLES; i++){
        samples[i] = thermistor.read();
        wait(0.1);
        }   
     // average all the samples out
    average = 0;
    for (i=0; i< NUMSAMPLES; i++) {
       average += samples[i];
    }
    average /= NUMSAMPLES;
   
    pc.printf("Average analog reading = %f\r\n", average); 
   
    // convert the value to resistance
    average = 1023 / average - 1;
    average = SERIESRESISTOR / average;
    pc.printf("Thermistor resistance = %f\r\n", average); 
   
    float steinhart;
    steinhart = average / THERMISTORNOMINAL;     // (R/Ro)
    steinhart = log(steinhart);                  // ln(R/Ro)
    steinhart /= BCOEFFICIENT;                   // 1/B * ln(R/Ro)
    steinhart += 1.0 / (TEMPERATURENOMINAL + 273.15); // + (1/To)
    steinhart = 1.0 / steinhart;                 // Invert
    steinhart -= 273.15;                         // convert to C
   
    pc.printf("Temperature = %f\r\n", steinhart);

    sensorReadings[count] = steinhart;
    wait(0.1);
  }

  for (count=0; count<8; count++) {
    pc.printf("Sensor #%f\r", count); 
    pc.printf(": %f\r\n", sensorReadings[count]);
  }
  wait(0.1);

}  




int main()
{
    for(int iX = 0; iX < 8; iX++){
        switch(iX){
            
            case 0:
                control1 = 0;
                control2 = 0;
                control3 = 0;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break; 
            case 1:
                control1 = 1;
                control2 = 0;
                control3 = 0;
                control4 = 0;
                control5 = 0;   
                procesamientoDatos(iX);
            break;
            case 2:
                control1 = 0;
                control2 = 1;
                control3 = 0;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break;
            case 3:
                control1 = 1;
                control2 = 1;
                control3 = 0;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break;
            case 4:
                control1 = 0;
                control2 = 0;
                control3 = 1;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break;
            case 5:
                control1 = 1;
                control2 = 0;
                control3 = 1;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break;
            case 6:
                control1 = 0;
                control2 = 1;
                control3 = 1;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break;
            case 7:
                control1 = 1;
                control2 = 1;
                control3 = 1;
                control4 = 0;
                control5 = 0;
                procesamientoDatos(iX);
            break;
            
            }
        }

}