#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "Hepta9axis.h"
#include "HeptaCamera_GPS.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);
HeptaTemp temp(p17);;
Hepta9axis n_axis(p28,p27,0xD0,0x18);
HeptaCamera_GPS cam_gps(p13,p14,p25,p24);
SDFileSystem sd(p5,p6,p7,p8,"sd");
HeptaBattery battery(p16,p26);
DigitalOut camera_switch(p25);
DigitalOut gps_switch(p24);
HeptaXbee xbee(p9,p10);

int main(){
    int rcmd=0,cmdflag=0,mflag;
    xbee.baud(9600);
    pc.baud(9600);
    float bt;
    float temper;
    float mx,my,mz;
    
    //SD Card
    char str[100];
    mkdir("/sd/mydir", 0777);
    
    //camera_switch=0;
    //gps_switch=1;
    cam_gps.gps_setting();
    int quality=0,stnum=0,gps_check=0;
    char ns='A',ew='B',aunit='m';
    float time=0.0,latitude=0.0,longtitude=0.0,hacu=0.0,altitude=0.0;
    xbee.printf("Sensor Detection\r\n");
    while(1){
        //Detect H.K. Data
        battery.vol(&bt);
        temp.temp_sense(&temper);
        xbee.printf("Vol=%f\r\n",bt);
        xbee.printf("temp=%f\r\n",temper);
        xbee.xbee_recieve(&rcmd,&cmdflag);
        if(cmdflag==1){
            if(rcmd=='a'){
                pc.printf("Command Get %d\r\n",rcmd);
                xbee.printf("HEPTA Uplink OK\r\n");
                cam_gps.flushSerialBuffer();
                FILE *fp = fopen("/sd/mydir/test.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                mflag = 0;
                for(int i=0;i<100;i++){
                    n_axis.sen_mag(&mx,&my,&mz);
                    cam_gps.gga_sensing(&time,&latitude,&ns,&longtitude,&ew,&quality,&stnum,&hacu,&altitude,&aunit,&gps_check);
                    if((gps_check==0)|(gps_check==1)){
                    //if(gps_check==1){
                        pc.printf("lat=%f,long=%f\r\n",latitude,longtitude);
                        fprintf(fp,"%d,%f,%f,%f,%f,%f\r\n",mflag,latitude,longtitude,mx,my,mz);
                        pc.printf("mflag=%d\r\n",mflag);
                        mflag++;
                    }
                    if(mflag==10){
                        fclose(fp);
                        break;  
                    }
                }
            }
            else if(rcmd=='b'){
                //Transmit Saved Mission Data
                pc.printf("Command Get %d\r\n",rcmd);
                xbee.printf("HEPTA Uplink OK\r\n");
                FILE *fp = fopen("/sd/mydir/test.txt","r");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                for(int i=0;i<10;i++){
                    fgets(str,100,fp);
                    xbee.puts(str);
                }
                fclose(fp);
            }
        xbee.initialize();
        }
                
        wait(1.0);

    }
}