//------------------------------------------------------------------------------
/* converteer de pulstrein naar een NEC code van 32-bit

element 0 van de array bevat de startsequentie
laag - hoog en wordt dus niet vertaald in bits
1 Pulstijd laag +  1 Pulstijd hoog = 0 Bit
1 Pulstijd laag +  3 Pulstijd hoog = 1 Bit

als de pulstijd HOOG minstens dubbel zo lang duurt als de pulstijd LAAG
wordt er de bit 1 gemaakt voor de code.
Alle andere voorwaarden geven een bit 0 voor de decodering,
zodat de actief lage pulsen worden omgezet in een actief hoge code.

Immers : een 1 in deze code, betekent IR-licht uitzenden op de Transmitter
         een 0 betekent geen IR-licht uitzenden

Terwijl: voor onze ontvanger geldt:
         een 1 lezen, betekent GEEN licht ontvangen
         een 0 lezen, betekent IR-licht ontvangen
*/
//------------------------------------------------------------------------------
unsigned long pulstrein_to_NEC_Code()
{
    // long kan 64 bit integer code aan
    const int BLen= 32 ; // Bit lengte van deze NEC_CODE
    unsigned long  NEC_Code=0 ;// tot max 64 bit code
    unsigned long flag=1;
    char byte[4]= {0,0,0,0};
    max_cnt=0;
    if (eLH_cnt>eHL_cnt) {
        max_cnt =eLH_cnt;
    } else {
        max_cnt =eHL_cnt;
    }
    if (max_cnt>BLen) { // enkel code produceren als 32-bit code volledig is
        // low bit first - high bit last
        for (int i=1; (i < BLen+1); i++) { // i = 0 is de startpuls
            // i = 1 is bit 0 --- i = 32 bit 31
            if ((dt_Low[i]*2 - dt_High[i] )>0) {
                // digitale 0, niets bijtellen
            } else {
                // digitale 1 : flag die telkens 1 bit wordt geshift naar links bijtellen
                NEC_Code = NEC_Code +flag;
            }
            flag=(flag<<1); // flag is flag * 2
        }
        printf("\r\nGelezen Nec_code        : %x\r\n",NEC_Code);
        printf("\r\n");

//    printf ("Druk op een toets om deze pulstrein weg te schrijven naar een file op de mBED \n\r");
//    pc.getc();    // wacht op een toets ingedrukt in Terminal. Enkel voor debugging
    }
    
    // test op de geldigheid van de ontvangen code
    // byte 0 MOET het inverse zijn van byte 1
    // en byte 3 MOET het inverse zijn van byte 4 om geldig te zijn
    byte[0]=((NEC_Code >>0)  & 0xff);
    byte[1]=!((NEC_Code>>8)  & 0xff); // invers moet gelijk zijn aan vorige byte
    byte[2]=((NEC_Code>>16)  & 0xff);
    byte[3]=!((NEC_Code>>24) & 0xff);// invers moet gelijk zijn aan vorige byte

    if (byte[0]& byte[1]) { 
    printf("\r\nOngeldige fabrikantcode: %x ",NEC_Code);
    NEC_Code=0;         
    }
   if (byte[2]& byte[3]) {
    printf("\r\nOngeldige toetscode: %x ",NEC_Code);
    NEC_Code=0; 
        
       
    }

    return (NEC_Code); // big endian formaat
/*
    zowel de Sparkfun afstandsbediening als de Optoma projector
    zijn gecodeerd volgens de NEC_Code pulstreinen
*/
}

//------------------------------------------------------------------------------
