/*------------------------------------------------------------------------------
Hardware : NUCLEO-F091RC board + IR-RX IR-Tx board + Soundcardscoop
STEM project, KU Leuven Campus Geel
-------------------------------------------------------------------
Pin PB_3 : D3: IR-Tx  Receiver CN9 pin3 --> wordt een TX disable niveau bij 1
                                        --> wordt een TX enable  niveau bij 0

Pin PB_4 : D5: IR-Rx  Receiver CN9 pin5 --> pin3 van de IR Receiver
Pin PC_7 : D9: PWM aansturing voor 38kHz op basis van de transistor BC547B
    de emittor van de transistor wordt naar massa aangesloten
    Collector is verbonden met 3,3V, IR-LED + serieweerstand van 18 Ohm
    zodat de stroom door de IR LED voldoende groot (>50mA )kan zijn
    om een grote afstand te kunnen overbruggen ( >5m)
----------------------------------------
---- Programmacode update 7-2-2017 -----
----------------------------------------
Volledig functioneel.
Via een terminal programma,( bv.  TerraTerm, Putty,Hyperterminal,.....)
zijn alle stappen die het programma doorloopt te volgen
Via de 'line in' van de soundcard, en het software programma
Cooledit ( geluid bewerkingsprogramma) of via Soundcard_Scope
zijn de ontvangen IR codes te analyseren op de PC.

1. Na reset zendt de IR-Tx LED de default GHost_Code uit
2. Lees via IR_Rx een NEC IR ontvangen code in en decodeer naar de fabrikantcode
3. Stuur de overeenkomstige GHost_Code uit via IR_Tx met de user_Button
4. stuur de laatst gestuurde code nogmaals via de user_button
5. test op correcte NEC_Codes om fouten van reflecties weg te filteren
*/
//------------------------------------------------------------------------------
#ifndef TARGET_NUCLEO
#define TARGET_NUCLEO
#endif

#include "mbed.h"
Timer program_timer; // timing van de activiteit van het hoofdprogramma


#ifdef TARGET_NUCLEO
// Pinbenamingen zijn enkel geldig voor het NUCLEO-F091RC bordje
// Voor andere bordjes, moet je de pinbenamingen aanpassen aan
// de functionalitijd van de beschikbare pinnen.

PwmOut IRLED(D9);       // IRLED freq. 38KHz via PWM CN9 Pin D9 (startpinnr at pin D0)
DigitalOut IR_disable(D3); // =0 om de emitter op massa te leggen met beperkt zendvermogen
                           //= 1 verhinder zenden
DigitalIn PTin( D5 ); // Pulstrein_input: lees het niveau van de pulstrein=IR Receiver CN9 pin D5
DigitalIn UserBlauw(USER_BUTTON); // PC_13 blauwe drukknop op het bordje

DigitalOut led1( D8 ); // Rode Led
DigitalOut led2( D7 ); // Oranje LED
DigitalOut led3( D6 ); // Groene LED
DigitalOut led4( D13); // PA_5 : LED op het BORDJE
#endif

//---------- Typecast alle variabelen ------------------------------------------

int dt_High[100]; // max 100 te registreren pulsen laag niveau
int dt_Low[100];  // max 100 te registreren pulsen hoog niveau
int eHL_cnt=-1, eLH_cnt=-1,min_idle=1;
int max_cnt=0;
char Toets[30]="Geen toets";

bool PInow=0; // Huidig ingangsniveau van de detector
bool PI=0;    // Vorig  ingangsniveau van de detector
bool IsHoog=0, IsLaag=0,Timed_Out=0;
bool debug=0; // debuging flag, voor extra info naar terminal

// -----------NEC Pulscode Timing voor TX --------------------------------------
#include "TX_IR_NEC.h"

//------------------------------------------------------------------------------
// Analyseer de ontvangen pulstrein
// Hieruit kun je informatie halen om andere pulscodetreinen te decoderen.
// Hiervoor moet je dan de converteer routine pulstrein_to_NECcode.h
// herschrijven.
#include "analyseer_pulstrein.h"

//------------------------------------------------------------------------------
// Flankdetectie en pulsduurregistratie in de arrays
// Hierna volgt de analyse van de pulstrein
#include "FlankDetectie.h"
#include "RX_Pulstrein.h"

//------------------------------------------------------------------------------
// converteer de pulstrein naar een NEC code
// vervang deze code eventueel door uw eigen decodeerprogramma
#include "pulstrein_to_NEC_code.h"

//------------------------------------------------------------------------------
// Reset alle variabelen van het programma
void reset_vars()
{
    eLH_cnt=-1;   // telt het aantalsen hoog
    eHL_cnt=-1;   // telt het aantalsen laag
    dt_Low[0]=0;  // duurtijd van de puls  laag = stijgende flank getetecteer
    dt_High[0]=0; // duurtijd van de puls  hoog = dalende flank getetecteer

    led1 = 0;     // reset toestand
    led2 = PTin;  // Blijft hoog als er GEEN IR wordt ontvangen
    led3 = 0;     //andere LEDs gedoofd
    led4 = 0;     // Groene LEDje LD2 op het NUCLEO bordje
    IsHoog =PInow;  // actief hoge variabele
    IsLaag =!PInow; // actief hoge variabele
}
//------------------------------------------------------------------------------
// Vertaal de ontvangen NEC_codes in een GhostCode indien
// aanwezig in de vertaaltabel.
// Anders stuur de code ongewijzigd door.
#include "Ghost_Codes.h"

int main()
{
     unsigned long Ghost_Code=0x7788CD32; // Optima projector menu Code
   unsigned long NEC_Code=Ghost_Code;   // NEC_Code = default na reset
    unsigned long New_Code=Ghost_Code;   // NEC_Code = default na reset
    int pr_cnt=0; // sec program counter
    int flag=0;
    program_timer.start(); // start timer
    program_timer.reset(); // zet timer =0
    PInow = PTin;  // lees het niveau vd RX pin pulstrein in rust
//--- Print Hello bericht naar terminal ----------------------------------------
 #include"hello_msg.h"
 
 //------------------------------------------------------------------------------

    while(1) { // hoofdloop stopt nooit
        flag=program_timer.read_ms();
        if  ( flag >  pr_cnt*1000 ) {
            reset_vars();          // Reset alle variabelen elke seconde
            Timed_Out=0;
            pr_cnt++;
            if (pr_cnt==1) { // stuur na 1 seconde de default ghost code uit
                // na een reset.
                stuur_Code(Ghost_Code);
                printf("\n\rDefault Ghost code send : %x\n\r\n\r",Ghost_Code);
            }
            printf ("%d sec : Klaar om een nieuwe code te ontvangen:\r",pr_cnt);
            printf ("%d \r",pr_cnt);
        }

        if (!UserBlauw) {        // userknop wordt ingedrukt
            while(!UserBlauw) {} // wacht tot de toets wordt losgelaten
            led3 =1; // Groene LED aan
            // verstuur de laatste ontvangen code nogeens uit.
            // of de default menucode voor de dataprojector na reset
            // Ghostcode voorlopig enkel geldig voor de dataprojector Optima
            // andere vertalingen moet je nog programmeren.

            Ghost_Code= Get_Ghost_Code(NEC_Code);
            printf("\r\nNEC code : %x vertaalt voor toets %s\r\n",NEC_Code,Toets);
            stuur_Code(Ghost_Code);
            printf("Ghost code send : %x\n\r\n\r",Ghost_Code);
            wait(0.5);
            reset_vars();          // Reset alle variabelen elke seconde

        }
        if (!PTin) { // IR ontvanger is hoog doe niets, wacht op dalende flank
            // Dalende flank gedetecteerd, start dan de pulstreindetectie.
            reset_vars();          // Reset alle variabelen elke seconde
            Timed_Out=0;
            led3 =1; // Groen LED aan
            RX_pulstrein();
            New_Code=pulstrein_to_NEC_Code(); // decodeer de pulstrein en genereer NEC_Code
            if(New_Code!=0) {
                if (NEC_Code != New_Code) { // codes ontvangen door reflecties wegfilteren
                    NEC_Code=New_Code; // nieuwe codes mogen door user_button verzonden worden
                    wait(0.1);
                    Ghost_Code= Get_Ghost_Code(NEC_Code); // zoek bijhorende toetsnaam en GhostCode
                    stuur_Code(Ghost_Code); // stuur de ontvangen NEC_code terug uit.
                    // Stuur de ghostcode nog niet uit
                    // Druk de blauwe user knop om de ghostcode uit te sturen
                    printf("Ghost code : %x vertaald voor toets %s\r\n\r\n",Ghost_Code,Toets);
                }
            }
        } else {
            // geen IR ontvangen, programma blijft zichtbaar actief via de LEDs
            flag=program_timer.read(); // lees seconden teller
            led1 = (flag & 1);  // flash LED1 in wacht mode elke 2 seconden
            led2 =PTin;         // Led2 brandt in rust
            led3 =!PTin;        // Led3 gedooft in rust
            led4 =(flag &2);    // flash LED4 in wacht mode elke 4 seconden
        }
    }
}
