// -----------NEC Pulscode Timing ----------------------------------------------
const float IR_Frequentie=38000.0; // 38kHZ IR frequentie
const float IR_ON=0.5;  // stuur dutycycle 50% vervangt IR=0;
const float IR_OFF=0.0; // stuur dutycycle 0%  vervangt IR=1;
// Dutycle aansturing via de basis van de transistor en PWM signaal
// vervangt aansturing via de emittor via IR=0 of IR=1 via pin TX
// D3 MOET wel als DigitalOut IR(D3) pin gedefinieerd worden
// D3 MOET laag staan om te kunnen zenden
// voor meer bereik, de extra testpin (anode van de diode) aan massa leggen

const int NEC_Time=562; // in microsec
const int NEC_Start_IRON=562*16;// in microsec
const int NEC_Start_IROFF=562*8;// in microsec
const int NEC_FrameTime=108; // ms

unsigned int NEC_Code=0xFB04F708; // NEC center toets

// FB04 High bytes = toetscode
// F708 low Bytes Fabrikant code voor NEC
// wordt low bit first en low byte first uitgezonden

//  IRLED=IR_OFF; // Stop sending IR Carrier. Zet PWM dutycycle op 0%
//  IRLED=IR_ON ; // Send IR Carrier. Zet PWM dutycycle op 50%

// -----------------------------------------------------------------------------
Timer Frame_timer; // Frame_timer voor frame timing
Timer timer;       // bittime counter

//---------------------------------------------------------------------------------------------------------------
void IR_Code_L0()    // Logisch=0 IR Code van de fabrikant
{
    timer.reset();
     IRLED=IR_ON ; // Send IR Carrier
    while (timer.read_us()< NEC_Time) { // Light on = 1TU for Nec
        /* Keep sending Ir signaal */
    }
    timer.reset();
    IRLED=IR_OFF ; // Stop sending IR Carrier
    while (timer.read_us()< NEC_Time) { // Light off = 1TU for Nec
        /* Stop sending Ir signaal */
    }
}
//---------------------------------------------------------------------------------------------------------------
void IR_Code_L1()    // // Logisch=1 IR Code van de fabrikant
{
    timer.reset();
    IRLED=IR_ON ; // Send IR Carrier
    while (timer.read_us()< NEC_Time) {// Light on = 1TU for Nec
        /* Keep sending Ir signaal */
    }
    timer.reset();
    IRLED=IR_OFF ; // Stop sending IR Carrier
    while (timer.read_us()< (NEC_Time*3)) { // Light off = 3TU for NEC
        /* Stop sending Ir signaal */
    }
}
//---------------------------------------------------------------------------------------------------------------
void stuur_Code( unsigned int NEC_Code)
{ 
// stuur de NEC_code, met NEC timing
// inclusief    Header frame
//              code + 1 extra bit
//              repeat code ( na de frame time)

    int bit=0;
  IR_disable=0 ; // om de emitter op massa te trekken
                  // zodat via de basis verder kan gestuurd worden
    IRLED.period(1.0/IR_Frequentie); //Drive IR LED data pin with 38Khz PWM Carrier
    IRLED = IR_OFF;               // Dutycycle 0% op basis van de transistor
    Frame_timer.start();  // Frametime counter
    timer.start();        // bittime counter
    
// ----- Start sending Command frame --------------------------
    IRLED=IR_ON ; // Send IR Carrier. Op Basis van de transistor Dutycycle 50%
    Frame_timer.reset();
    timer.reset();
    while (timer.read_us()< NEC_Start_IRON) {// Light on
        /* Keep sending Ir signaal */
    }
    timer.reset();
    IRLED=IR_OFF ; // Stop sending IR Carrier
    while (timer.read_us()< NEC_Start_IROFF) { // Light off
        /* Stop sending Ir signaal */
    }
// -- Start sending 32 NEC Code ------------------------------------------------
    for (int i=0; i < 32; i++) {
        bit= (NEC_Code &1); // low bit first
        NEC_Code=(NEC_Code>>1); // volgende te versturen bit klaarzetten
        if (bit) {
            IR_Code_L1(); // stuur logisch 1
        } else {
            IR_Code_L0(); // stuur logisch 0
        }
    }
    IR_Code_L1(); // stuur logisch 1 send 1 trailing bit
// --- Start sending IR=1 Frametime -----------------------------------------
    IRLED=IR_OFF; // Stop sending IR Carrier
    while (Frame_timer.read_ms()< NEC_FrameTime) { // Light off
        /* Stop sending Ir signaal */
    }
// --- Start sending Repeat frame -----------------------------------------
    timer.reset();
    IRLED=IR_ON ; // Send IR Carrier
    while (timer.read_us()< NEC_Start_IRON) {// Light on
        /* Keep sending Ir signaal */
    }
    timer.reset();
    IRLED=IR_OFF ; // Stop sending IR Carrier
    while (timer.read_us()< (NEC_Start_IROFF/2)) { // Light off
        /* Stop sending Ir signaal */
    }
    IR_Code_L0(); // stuur logisch 0
    IR_disable=1 ; // om de emitter op 1 te trekken
                   // IR transmitter valt af
 
// --- Stop sending Repeat frame ------------------------------
    Frame_timer.stop();
    timer.stop();
}