//******************************************************************************************
//* IR send and receive demo                                                               *
//* myled1 and myled2 indicate TX/RX activity                                              *
//* Character typed in PC terminal application sent out using IR transmitter LED on D3 pin *
//* and echoed back using IR receiver on D5 pin                                            *
//******************************************************************************************
#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx default USB connection to pc
Serial device(D3,D5);    // IR_tx pin, IR_rx pin
//Serial device(PB_3,PB_4);  // IR_tx pin, IR_rx pin : this is also working

DigitalOut myled1(D8);  // Red Led
DigitalOut myled2(D7);  // Orange Led
DigitalOut myled3(D6);  // Green Led
PwmOut IRLED(D9);       // IR Carrier signal 38kHz, 50% Dutycycle

int main() 
{
    char pcchar;   // define variable pcchar received via Terminal from pc keyboard
    char devchar;  // define variable devchar received via IR receiver
    
    IRLED.period(1.0/38000.0);  // IR transmit frequenty 38kHz
    IRLED = 0.5;                // dutycycle 50%
    
     //IR Transmit code
     //Drive IR LED gnd pin with serial TX device pin
    device.baud(2400);
    
    printf("Programstart\r\n");
    while(1) {
        myled3=!myled3;
        wait(0.05);
        if(pc.readable()) {
            myled1 = !myled1;;
            pcchar=pc.getc();
            device.putc(pcchar);
           
        }
        //IR Receive code
        if(device.readable()) {
           // myled2 = 1;
            devchar=device.getc();
            pc.putc(devchar);
            myled2 = !myled2;
         }
    }
}
