#include "mbed.h" // this need older version of mbed library 
#include "MFRC522.h"
#include "WIZnetInterface.h"
#include "HTTPClient.h"
 
#define USE_W5100
#define ST_NUCLEO
 
//MFRC522 SPI interface
#define SPI_MOSI    PB_5
#define SPI_MISO    PB_4
#define SPI_SCLK    PB_3
#define SPI_CS      PA_10
#define MF_RESET    PA_2

//Ethernet
#define SPI_MOSI_ETH    PA_7
#define SPI_MISO_ETH    PA_6
#define SPI_SCLK_ETH    PA_5
#define SPI_CS_ETH      PB_6
#define RESET_ETH       PB_2

//LEDS
#define LED_RED PA_12
#define LED_GREEN PB_12
#define LED_ORANGE PA_11

//Buzzer
#define BUZZER PC_8

//Electronic LOCK
#define LOCK PC_6

DigitalOut LedRed(LED_RED);
DigitalOut LedGreen(LED_GREEN);
DigitalOut LedOrange(LED_ORANGE);

DigitalIn config_button(PC_13);

DigitalOut Lock(LOCK);

PwmOut buzzer(BUZZER);

const char * IP_Addr = "192.168.0.2";
const char * IP_Subnet = "255.255.255.0";
const char * IP_Gateway = "192.168.0.1";
unsigned char MAC_Addr[6] = {
    0x90,
    0xA2,
    0xDA,
    0x0F,
    0x5B,
    0x83
};

unsigned char zone_uid;

Serial pc(PA_0, PA_1);
MFRC522 RfChip(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);
WIZnetInterface ethernet(SPI_MOSI_ETH, SPI_MISO_ETH, SPI_SCLK_ETH, SPI_CS_ETH, RESET_ETH);

void buzzer_stop() {
    buzzer.write(0);
}

Timeout buzzer_timeout;

I2C eeprom(PB_9, PB_8);

int main(void) {
    pc.puts("Unit start\n\r");

    eeprom.start();
    eeprom.write(0b10100000); //Control byte b1=0;b2=0;WRITE
    eeprom.write(128); // Address    

    wait(0.5);

    eeprom.start();
    eeprom.write(0b10100001); //Control byte b1=0;b2=0;READ

    int zone_uid = eeprom.read(0);

    eeprom.stop();

    if (!config_button) {
        pc.printf("Old zone: %d\n\r", zone_uid);

        pc.puts("Send new zone uid in format ddd_\n\r");

        int i = 0;
        char in , buffer[12];
        int new_uid = 1;

        in = pc.getc();
        while ( in != '_') {
            buffer[i++] = in ;
            if (i == 12) {
                break;
            } in = pc.getc();
        }
        buffer[i] = 0;

        pc.printf("Income string: %s\n\r", buffer);

        new_uid = strtol(buffer, NULL, 10);

        if (new_uid > 0 && new_uid < 256) {
            eeprom.start();
            eeprom.write(0b10100000); //Control byte b1=0;b2=0;WRITE
            eeprom.write(128); // Address
            eeprom.write((char) new_uid);
            eeprom.stop();

            zone_uid = new_uid;
        } else {
            pc.puts("Error\n\r");
        }
    }

    pc.printf("Current zone: %d\n\r", zone_uid);

    char card_uid[20];
    uint8_t i;

    buzzer.period_us(250);

    //Init sequence
    for (i = 0; i < 4; i++) {
        if ((i % 2) == 0) {
            buzzer.write(0.5f);
        } else {
            buzzer.write(0);
        }

        switch (i) {
            case 0:
                {
                    LedRed = 1;
                    break;
                }
            case 1:
                {
                    LedRed = 0;
                    LedGreen = 1;
                    break;
                }
            case 2:
                {
                    LedGreen = 0;
                    LedOrange = 1;
                    break;
                }
            case 3:
                {
                    LedOrange = 0;
                    break;
                }
        }

        wait(0.25f);
    }
    buzzer.write(0);

    //Init ethernet    
    int ret = ethernet.init(MAC_Addr, IP_Addr, IP_Subnet, IP_Gateway);
    if (ret == 0) {
        //pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (ret == 0) {
            pc.printf("Initialized / MAC: %s, IP: %s, MASK: %s, GW: %s\r\n",
                ethernet.getMACAddress(), ethernet.getIPAddress(),
                ethernet.getNetworkMask(), ethernet.getGateway());
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            while (1) {
                LedRed = !LedRed;
                wait(0.25f);
            }
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        while (1) {
            LedRed = !LedRed;
            wait(0.25f);
        }
    }

    // Init. RC522 Chip
    RfChip.PCD_Init();

    //MAIN
    while (true) {
        LedRed = 1;
        LedGreen = 0;
        LedOrange = 0;

        // Look for new cards
        if (!RfChip.PICC_IsNewCardPresent()) {
            wait_ms(250);
            continue;
        }

        // Select one of the cards
        if (!RfChip.PICC_ReadCardSerial()) {
            wait_ms(250);
            continue;
        }

        LedRed = 0;
        LedOrange = 1;
        /*
        buzzer.write(0.5f);
        buzzer_timeout.attach(&buzzer_stop, 0.25f);
        */

        // Print Card UID
        pc.printf("Card UID: ");


        for (i = 0; i < sizeof(card_uid); i++) {
            card_uid[i] = 0;
        }

        for (i = 0; i < RfChip.uid.size; i++) {
            sprintf(card_uid, "%s%X02", card_uid, RfChip.uid.uidByte[i]);
        }

        pc.puts(card_uid);
        pc.printf(" end\n\r");


        //Send to server to authorize
        char str[512];
        char get_msg[512];
        HTTPClient http;

        sprintf(get_msg, "http://192.168.0.1:8080/card.php?card_uid=%s&zone_uid=%d", card_uid, zone_uid);

        pc.printf("msg : %s\r\n", get_msg);
        ret = http.get(get_msg, str, sizeof(str));
        if (!ret) {
            pc.printf("\r\nREQUEST SUCCESS - read %d characters\n\r", strlen(str));
            pc.printf("Result: %s\n\r", str);
        } else {
            pc.printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
        }

        //check server response
        LedOrange = 0;
        LedRed = 0;

        if (strcmp(str, "PERMITTED") == 0) {
            Lock = 1;
            LedGreen = 1;

            buzzer.write(0.5f);
            buzzer_timeout.attach( & buzzer_stop, 0.5f);
            wait(3);

            Lock = 0;
        } else if (strcmp(str, "DENIED") == 0) {
            buzzer.write(0.5f);
            for (i = 0; i < 6; i++) {
                LedRed = !LedRed;
                wait(0.25f);
            }
        } else {
            for (i = 0; i < 6; i++) {
                LedOrange = !LedOrange;
                LedRed = !LedRed;

                if (LedRed.read() == 1) {
                    buzzer.write(0.5f);
                } else {
                    buzzer.write(0);
                }
                wait(0.25f);
            }
        }

        LedRed = 0;
        LedGreen = 0;
        LedOrange = 0;
        buzzer.write(0);
        wait(0.5);
    }

}