#include "touch_tft.h"
#include "SPI_TFT_ILI9341.h"
#include "USBMIDI.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

// Function to power down magic USB interface chip with new firmware
#define USR_POWERDOWN    (0x104)
int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

void powerdown(void)
{

    PHY_PowerDown();
    semihost_powerdown();
    //Peripheral_PowerDown(0xFFFF7FFF);

    PHY_PowerDown();                    //Ethernet disabled
    semihost_powerdown();               //USB disabled
    Peripheral_PowerDown(0x80080);      //Unused I2C disabled

}

// short slider = 8192;
extern unsigned short Oct = 36;        //default octave C1

// the TFT is connected to SPI pin 5-7
// the touch is connected to 19,20,17,18
touch_tft tft(p20,p19,p18,p17,p5, p6, p7, p14, p15, p21, "TFT"); // x+,x-,y+,y-,mosi, miso, sclk, cs, reset, dc
DigitalIn  key[9] = {p22, p23, p24, p25, p26, p27, p28, p29, p30};       //inputit

unsigned char i;
bool pressed_keys[9] = {0};

USBMIDI midi;

void Nine_keys(void)
{
    for (i = 0; i < 9; i++) {
        if (!key[i].read() & !pressed_keys[i]) {
            midi.write(MIDIMessage::NoteOn(Oct + i));
            pressed_keys[i] = true;
        }
        if (key[i].read() & pressed_keys[i]) {
            midi.write(MIDIMessage::NoteOff(Oct + i));
            pressed_keys[i] = false;
        }
    }
}

void Buttons(unsigned char b, unsigned short color)              //Button Field
{
    if (b == 1) {                                      //Slider
        tft.fillrect(3,96,78,318,color);
    }
    if (b == 2) {                                      //Octave Reset
        tft.fillrect(163,163,238,238,color);
    }
    if (b == 3) {                                      //Octave DOWN
        tft.fillrect(83,243,158,318,color);
        tft.locate(90,275);
        tft.foreground(Black);
        tft.background(White);
        printf("DOWN");
        tft.foreground(White);
        tft.background(Black);

    }
    if (b == 4) {                                      //Octave UP
        tft.fillrect(163,243,238,318,color);
        tft.locate(170,275);
        tft.foreground(Black);
        tft.background(White);
        printf("UP");
        tft.foreground(White);
        tft.background(Black);
    }
}

void Draw_buttons(unsigned short color)                //Draws Button Field
{
    unsigned char i = 0;

    for (i = 0; i<5; i++) {
        //tft.locate(10,50);
        Buttons(i, color);
    }
}



void Slider_action(point p)
{
    if (p.x > 3 && p.x < 78) {                          //Slider
        if (p.y > 88 && p.y < 111) {
            tft.fillrect(3,88,78,111,Red);
            midi.write(MIDIMessage::PitchWheel(8192));
        }
        if (p.y > 111 && p.y < 134) {
            tft.fillrect(3,111,78,134,Red);
            midi.write(MIDIMessage::PitchWheel(6400));
        }
        if (p.y > 134 && p.y < 157) {
            tft.fillrect(3,111,78,157,Red);
            midi.write(MIDIMessage::PitchWheel(4915));
        }
        if (p.y > 157 && p.y < 180) {
            tft.fillrect(3,111,78,180,Red);
            midi.write(MIDIMessage::PitchWheel(3277));
        }
        if (p.y > 180 && p.y < 203) {
            tft.fillrect(3,111,78,203,Red);
            midi.write(MIDIMessage::PitchWheel(1638));
        }
        if (p.y > 203 && p.y < 226) {
            tft.fillrect(3,111,78,226,Red);
            midi.write(MIDIMessage::PitchWheel(0));
        }
        if (p.y > 226 && p.y < 249) {
            tft.fillrect(3,111,78,249,Red);
            midi.write(MIDIMessage::PitchWheel(-1638));
        }
        if (p.y > 249 && p.y < 272) {
            tft.fillrect(3,111,78,272,Red);
            midi.write(MIDIMessage::PitchWheel(-3277));
        }
        if (p.y > 272 && p.y < 295) {
            tft.fillrect(3,111,78,295,Red);
            midi.write(MIDIMessage::PitchWheel(-4915));
        }
        if (p.y > 295 && p.y < 318) {
            tft.fillrect(3,111,78,318,Red);
            midi.write(MIDIMessage::PitchWheel(-8192));
        }
    }
}


void Octave_buttons(unsigned short color, point p)
{
    if (p.y > 243 && p.y < 318) {           //ROW C
        if (p.x > 83 && p.x < 158) {        //Octave down
            Buttons(3, color);
            Oct -= 12;
            tft.locate(90,275);
            tft.foreground(Black);
            tft.background(Red);
            printf("Down");
            tft.foreground(Black);
            tft.background(White);
            wait(0.2);
            Buttons(3, White);
        }
        if (p.x > 163 && p.x < 238) {       //Octave up
            Buttons(4, color);
            Oct += 12;
            tft.locate(170,275);
            tft.foreground(Black);
            tft.background(Red);
            printf("UP");
            tft.foreground(Black);
            tft.background(White);
            wait(0.2);
            Buttons(4, White);

        }
    }

    if (p.y > 163 && p.y < 238) {            //ROW B
        if (p.x > 163 && p.x < 238) {       //Octave reset
            Oct = 36;
            Buttons(2, Cyan);
            wait(0.2);
            Buttons(2, White);
        }
    }

    if (Oct > 120) Oct -=12;               //Octave range 12-120.
    if (Oct < 12) Oct +=12;
}



