/* mbed SCA61T Single Axis Inclinometer
* Copyright (c) 2010 Veikko Soininen
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#include "SCA61T.h"

// ** Class

static int sel;

SCA61T::SCA61T(PinName mosi, PinName miso, PinName sclk, PinName csb, int device_sel)
    : SPI_m(mosi, miso, sclk)
    , CSB_m(csb) {
    sel=device_sel; 
    CSB_m=1;
    SPI_m.frequency(500000);
}

// ** SPI

uint8_t SCA61T::SPI_ReadReg(uint8_t reg)
{
    uint8_t reply;

    CSB_m=0;
    SPI_m.write(reg);
    reply = SPI_m.write(0x00);
    CSB_m=1;

    return reply;
}

void SCA61T::SPI_ReadWord(uint8_t cmd, char* table)
{
    CSB_m=0;
    SPI_m.write(cmd);
    for(int i=0;i<2;i++)
        *table++ = SPI_m.write(0x00);
    CSB_m=1;
}

void SCA61T::SPI_Command(uint8_t cmd)
{
    CSB_m=0;
    SPI_m.write(cmd);
    CSB_m=1;
}

// ** SCA61T

float SCA61T::ReadX()
{
    uint8_t temp[2];
    uint16_t data;
    float device_sens;
    float angle;

    if(sel)
        device_sens = 819.00;
    else
        device_sens = 1638.00;

    SPI_ReadWord(0x10,(char*)temp);
    
    temp[1] = (temp[1]>>5);
    data=(temp[0]<<3)+temp[1];

    angle=asinf((data-1024.00f)/device_sens)*(180.00f/3.14f);

    return angle;
}

int8_t SCA61T::ReadTemp()
{
    int temp;

    temp=SPI_ReadReg(0x08);
    temp=rint((temp-197.000)/(-1.083));

    return temp;
}

void SCA61T::MeasMode()
{
    SPI_Command(0x00);
}

uint8_t SCA61T::ReadStatus()
{
    return SPI_ReadReg(0x0A);
}

void SCA61T::ReloadNV()
{
    SPI_Command(0x0B);
}

void SCA61T::SelfTest()
{
    SPI_Command(0x0E);
}
