#include "mbed.h"
#include "N5110.h"
#include "Reket.h"
#include "Loptica.h"

Reket rLijevi (2, 3, 21, 28);
Reket rDesni (80, 81, 21, 28);
Loptica loptica (41, 12, 2, 1);

int p1_skor = 0;
int p2_skor = 0;

int zaustaviX, zaustaviY;

N5110 display(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
DigitalOut enable (dp14);

AnalogIn P1(dp9);
AnalogIn P2(dp10);

InterruptIn taster(dp1);
Ticker t;
Timer dbnc;
Timer dvostruki;

bool pauza = true;
bool poen = false;
bool reset = false;

void Lcifre(int cifra)
{
    if(cifra == 0)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 1);    
        for(int i = 0; i < 5; i++)
            display.setPixel(34, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 5);
        for(int i = 0; i < 5; i++)
            display.setPixel(31, 1 + i);
    }
    else if(cifra == 1)
    {
        for(int i = 0; i < 5; i++)
            display.setPixel(34, 1 + i);        
    }
    else if(cifra == 2)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 1);
        for(int i = 0; i < 3; i++)
            display.setPixel(34, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 3);
        for(int i = 0; i < 3; i++)
            display.setPixel(31, 3 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 5);
    }   
    else if(cifra == 3)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 1);
        for(int i = 0; i < 5; i++)
            display.setPixel(34, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 3);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 5);      
    }
    else if(cifra == 4)
    {
        for(int i = 0; i < 3; i++)
            display.setPixel(31, 1 + i);
        for(int i = 0; i < 5; i++)
            display.setPixel(34, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 3);        
    }     
    else if(cifra == 5)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 1);
        for(int i = 0; i < 3; i++)
            display.setPixel(31, i + 1);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 3);
        for(int i = 0; i < 3; i++)
            display.setPixel(34, i + 3);
        for(int i = 0; i < 4; i++)
            display.setPixel(31 + i, 5);        
    }            
   display.refresh(); 
}

void Rcifre(int cifra)
{
    if(cifra == 0)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 1);    
        for(int i = 0; i < 5; i++)
            display.setPixel(48, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 5);
        for(int i = 0; i < 5; i++)
            display.setPixel(51, 1 + i);
    }
    else if(cifra == 1)
    {
        for(int i = 0; i < 5; i++)
            display.setPixel(48, 1 + i);        
    }
    else if(cifra == 2)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 1);
        for(int i = 0; i < 3; i++)
            display.setPixel(51, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 3);
        for(int i = 0; i < 3; i++)
            display.setPixel(48, 3 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 5);
    }   
    else if(cifra == 3)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 1);
        for(int i = 0; i < 5; i++)
            display.setPixel(51, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 3);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 5);      
    }
    else if(cifra == 4)
    {
        for(int i = 0; i < 3; i++)
            display.setPixel(48, 1 + i);
        for(int i = 0; i < 5; i++)
            display.setPixel(51, 1 + i);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 3);        
    }     
    else if(cifra == 5)
    {
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 1);
        for(int i = 0; i < 3; i++)
            display.setPixel(48, i + 1);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 3);
        for(int i = 0; i < 3; i++)
            display.setPixel(51, i + 3);
        for(int i = 0; i < 4; i++)
            display.setPixel(48 + i, 5);        
    }
   display.refresh(); 
}

void Lbrisi()
{
    for(int i = 0; i < 4; i++)
        display.clearPixel(31 + i, 1);    
    for(int i = 0; i < 5; i++)
        display.clearPixel(34, 1 + i);
    for(int i = 0; i < 4; i++)
        display.clearPixel(31 + i, 3);
    for(int i = 0; i < 4; i++)
        display.clearPixel(31 + i, 5);
    for(int i = 0; i < 5; i++)
        display.clearPixel(31, 1 + i);
    display.refresh();
}

void Rbrisi()
{
    for(int i = 0; i < 4; i++)
        display.clearPixel(48 + i, 1);    
    for(int i = 0; i < 5; i++)
        display.clearPixel(51, 1 + i);
    for(int i = 0; i < 4; i++)
        display.clearPixel(48 + i, 3);
    for(int i = 0; i < 4; i++)
        display.clearPixel(48 + i, 5);
    for(int i = 0; i < 5; i++)
        display.clearPixel(48, 1 + i);
    display.refresh();
}

void igraj()
{
    if(poen) return;
    
    for(int i = 0; i < 47; i++)
        display.setPixel(41, i);
    display.refresh();
    
    rLijevi.brisiReket(display);
    if(!pauza)
        rLijevi.osvjeziPoziciju(P1);
    rLijevi.crtajReket(display);
    
    rDesni.brisiReket(display);
    if(!pauza)
        rDesni.osvjeziPoziciju(P2);
    rDesni.crtajReket(display);
    
    loptica.brisiLopticu(display);
    if(!pauza)
        loptica.osvjeziPoziciju();
    loptica.crtajLopticu(display);
    
    if(loptica.dajX() <= 5)
    {
        if(loptica.dajY() == rLijevi.dajY1() or loptica.dajY() == rLijevi.dajY1() + 1)
            loptica.postaviKorak(2, -2);
        else if (loptica.dajY() == rLijevi.dajY1() + 2 or loptica.dajY() == rLijevi.dajY1() + 3)
                loptica.postaviKorak(2, -1);
        else if (loptica.dajY() == rLijevi.dajY1() + 4)
                loptica.postaviKorak(2, 0);
        else if (loptica.dajY() == rLijevi.dajY1() + 5 or loptica.dajY() == rLijevi.dajY1() + 6)
                loptica.postaviKorak(2, 1);
        else if (loptica.dajY() == rLijevi.dajY1() + 7 or loptica.dajY() == rLijevi.dajY1() + 8)
                loptica.postaviKorak(2, 2);
    }
    
    if(loptica.dajX() >= 0 and loptica.dajX() < 2)
    {
        if((loptica.dajY() < rLijevi.dajY1() - 1) or (loptica.dajY() > rLijevi.dajY2() + 1))
        {
            p2_skor++;
            loptica.brisiLopticu(display);
            loptica.setX(41);
            loptica.setY(12);
            loptica.postaviKorak(2, 1);
            if(p2_skor == 5)
                poen = true;
            else return;
        }
    } 
    
    if(loptica.dajX() >= 78)
    {
        if(loptica.dajY() == rDesni.dajY1() or loptica.dajY() == rDesni.dajY1() + 1)
            loptica.postaviKorak(-2, -2);
        else if(loptica.dajY() == rDesni.dajY1() + 2 or loptica.dajY() == rDesni.dajY1() + 3)
                loptica.postaviKorak(-2, -1);
        else if(loptica.dajY() == rDesni.dajY1() + 4)
                loptica.postaviKorak(-2, 0);
        else if(loptica.dajY() == rDesni.dajY1() + 5 or loptica.dajY() == rDesni.dajY1() + 6)
                loptica.postaviKorak(-2, 1);
        else if(loptica.dajY() == rDesni.dajY1() + 7 or loptica.dajY() == rDesni.dajY1() + 8)
            loptica.postaviKorak(-2, 2);
    }
    
    if(loptica.dajX() >= 81 and loptica.dajX() <= 83)
    {
        if((loptica.dajY() < rDesni.dajY1() - 1) or (loptica.dajY() > rDesni.dajY2() + 1))
        {
            p1_skor++;
            loptica.brisiLopticu(display);
            loptica.setX(41);
            loptica.setY(12);
            loptica.postaviKorak(-2, 1);
            if(p1_skor == 5)
                poen = true;
            else return;
        }
    }
    
    if(loptica.dajY() <= 1 or loptica.dajY() >= 46)
        loptica.postaviKorak(loptica.dajKorakX(), loptica.dajKorakY() * (-1));
    
    Lbrisi();
    Rbrisi();
    Lcifre(p1_skor);
    Rcifre(p2_skor);
    
    if(poen)
    {
        loptica.setX(41);
        loptica.setY(12);
        loptica.postaviKorak(0, 0);
        if(p1_skor == 5) display.printString("P1WINS", 2, 2);
        if(p2_skor == 5) display.printString("P2 WINS", 43, 2);
    }
    
    if(reset)
    {
        loptica.setX(41);
        loptica.setY(12);
        loptica.postaviKorak(-2, 1);
        display.clear();
        reset = false;
        poen = false;
        p1_skor = 0;
        p2_skor = 0;
    }
}

void pauzaStartRestart()
{
    if(dbnc.read_ms() > 200 and dvostruki.read_ms() > 800)
    {
        dbnc.reset();
        dvostruki.reset();
        pauza = !pauza;
    }
    
    if(dvostruki.read_ms() < 800 and dbnc.read_ms() > 200)
    {
        reset = true;
        poen = false;
        dbnc.reset();
        dvostruki.reset();
    }
}

int main() {
    enable = 1;
    display.init();
    display.setXYAddress(0, 0);
    taster.rise(&pauzaStartRestart);
    t.attach(&igraj, 0.08);
    dbnc.start();
    dvostruki.start();
    while(1) {}
}
