// Sweep the motor speed from full-speed reverse (-1.0) to full speed forwards (1.0)

#include "mbed.h"
#include "Motor.h"
#include "PinDetect.h"
#include "Servo.h"

Servo myservo(p21);
Motor m1(p24, p17, p18); // pwm, fwd, rev
Motor m2(p25, p19, p20); // pwm, fwd, rev
PinDetect pb1(p7);
PinDetect pb2(p8);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4); 

void pb1_hit_callback (void) {
    myled3 = !myled3;
    m1.speed(0.5); 
    wait(0.05);
    m1.speed(0.0);
    wait(0.05);
    m1.speed(-0.5); 
    wait(0.05);
    m1.speed(0.0);
}

void pb2_hit_callback (void) {
    myled4 = !myled4;
    m2.speed(0.5); 
    wait(0.05);
    m2.speed(0.0);
    wait(0.05);
    m2.speed(-0.5); 
    wait(0.05);
    m2.speed(0.0);
}

int main() {
    // Use internal pullups for pushbutton
    pb1.mode(PullUp);   
    pb2.mode(PullUp);  
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    
    while (1) {
        myservo = 0.0;
        wait(0.5);
        myservo = -1.0;
        wait(0.5);
    }
}
