// Original program found here: http://playground.arduino.cc/Main/I2cScanner
// Modified by Domen Ornik, 4.5.2015
// Modified by Valon Hoti 27.08.2017 00:40
#include "mbed.h"
 
I2C i2c(I2C_SDA , I2C_SCL ); 
 
int main() {
    printf("\nI2C Scanner");
    
    while(1) {
        int error, address;
        int nDevices;
      
        printf("Scanning...\n");
        
         nDevices = 0;
         
          for(address = 1; address < 127; address++ ) 
          {
            i2c.start();
            error = i2c.write(address << 1); //We shift it left because mbed takes in 8 bit addreses
            i2c.stop();
            if (error == 1)
            {
              printf("I2C device found at address 0x%X", (address >>1); //Returns 8-bit addres
              nDevices++;
            }
 
          }
          if (nDevices == 0)
            printf("No I2C devices found\n");
          else
            printf("\ndone\n");
        
          wait(5);           // wait 5 seconds for next scan
          
            }
        }