#include "mbed.h"
#include "rtos.h"
#include "rtos_serial.h"
#include "tRDM880.h"

#define TXD     p28
#define RXD     p27

#define ID 0x222

CAN CanPort(p30, p29);
CANMessage  MessageTx;

int main() 
{
    unsigned char Data[100];
    int Res;
    tCSN    CardNumber;
    unsigned char Status;
    
    RTOS_Serial Uart(TXD, RXD);
    tRdm880 Reader(&Uart);
    
    while(1){
        
        Reader.SendGetID();
        Res = Reader.GetResponse(Data);
        
        Status = Reader.getStatus(Data);
        
        if (Status == CMD_OK){
            
            Res = Reader.getCardSerialNumber(Data,&CardNumber);
            
            if (Res == 0){      
                    printf("CARD ID = %04X %08X %08X\n",CardNumber.VeryHigh16b,CardNumber.High32b,CardNumber.Low32b);  
                    
                    MessageTx.data[0] = CardNumber.High32b >> 24;
                    MessageTx.data[1] = CardNumber.High32b >> 16;
                    MessageTx.data[2] = CardNumber.High32b >> 8;
                    MessageTx.data[3] = CardNumber.High32b;
                    
                    MessageTx.data[4] = CardNumber.Low32b >> 24;
                    MessageTx.data[5] = CardNumber.Low32b >> 16;
                    MessageTx.data[6] = CardNumber.Low32b >> 8;
                    MessageTx.data[7] = CardNumber.Low32b;
                     
                    MessageTx.id=ID;
                    CanPort.write(MessageTx);//on envoi 8 octets
                    
            } else {
                printf("ID ERROR\n");
            }
                
        }else {
                printf("NO CARD\n");
        }
        
        
        
        
        wait(0.5);
    }
}


