/*
 * Temperature & hummidity sensor operations
 */
#include "mbed.h"
#include "rtos.h"

#include "main.h"
#include "temp_hum_sensor.h"
#include "DHT.h"

static DHT DHTSensor(D3, DHT11);
static DigitalOut  DHTEnable(D7);
static float tempCurr, humCurr, dewPCurr;
uint32_t temp_hum_init(void const *args)
{

    return 1;
}
void temp_hum_thread(void const *args)
{
//DEBUG
    mutexPCComm.lock();
    pc.printf("SENSOR: thread init\n");
    mutexPCComm.unlock();
    int8_t error = 0;
    int8_t attempts=0;
    while(true) {
        Thread::signal_wait(0);
        mutexPCComm.lock();
        pc.printf("SENSOR: loop\n");
        mutexPCComm.unlock();
        error = -1;
        attempts=0;
        while(error!=0 && attempts<MAX_READ_ATTEMPTS_TEMP_HUM && sensors_running == true) {
            error = DHTread();
            if(error==0) {
                mutexData.lock();
                data.temperature = tempCurr;
                data.humidity = humCurr;
                data.dewPoint = dewPCurr;
                data.DHTError = 0;
                mutexData.unlock();
            } else {
                mutexData.lock();
                data.DHTError = error;
                mutexData.unlock();
                attempts++;
                Thread::wait(3000);
                 //DEBUG
                mutexPCComm.lock();
                printf("DHTError: %d\n", error);
                mutexPCComm.unlock();
                
            }
            /*
            // DEBUG
            mutexPCComm.lock();
            printf("DHTError: attempt %d %d %d %4.2f\n", attempts, error,sensors_running,tempCurr);
            mutexPCComm.unlock();
            */
        } // while read attempts
    } // main thread while
} // thread function

int DHTread(void)
{
    int error = 0;
    DHTEnable = 1;
    Thread::wait(1000);
    error = DHTSensor.readData();
    if (error == 0) {
        tempCurr = DHTSensor.ReadTemperature(CELCIUS);
        humCurr = DHTSensor.ReadHumidity();
        dewPCurr = DHTSensor.CalcdewPoint(tempCurr, humCurr);
    }
    DHTEnable=0;
    return error;
}