#include "mbed.h"
#include "real_time_clock.h"
Ds3231 rtc(D14, D15);

int setupRTC(void)
{
    int error = 0;
    char temp[255];
    int token_count = 0;
    int time_data[7];
    ds3231_cntl_stat_t rtc_control_status = {0,0};
    ds3231_time_t rtc_time;
    ds3231_calendar_t rtc_calendar;

    scanf("%d", &temp);
    char * pch;
    pch = strtok (temp,",");
    do {

        printf ("Insert DOW,DOM,M,Y,H,m,S\n");
        while (pch != NULL) {
            if(token_count>=7) {
                error = 1;
                break;
            }
            time_data[token_count] = atoi(pch);
            token_count++;
        }
    } while(error==0);

    rtc.set_cntl_stat_reg(rtc_control_status);
    rtc_calendar.day=time_data[0];
    rtc_calendar.date=time_data[1];
    rtc_calendar.month=time_data[2];
    rtc_calendar.year=time_data[3];
    rtc_time.mode=0;
    rtc_time.hours=time_data[4];
    rtc_time.minutes=time_data[5];
    rtc_time.seconds=time_data[6];
    
    //Set the time, uses inverted logic for return value
    if(rtc.set_time(rtc_time)) {
        printf("\nrtc.set_time failed!!\n");
        error = 2;
    }

    //Set the calendar, uses inverted logic for return value
    if(rtc.set_calendar(rtc_calendar)) {
        printf("\nrtc.set_calendar failed!!\n");
        error = 3;
    }
    return error;
}