/*
 * MAIN.H
 */
#ifndef MAIN_H
#define MAIN_H
#define MAX_TIME_TO_WAIT_NODE_COMM 13

struct SensorData{
    float temperature;
    float humidity;
    float dewPoint;
    int8_t DHTError;
    float light;
    int8_t lightError;
};

struct task_definition_struct {
    void(*task)(void const *args);
    uint32_t(*init)(void const *args); // Result: 1 = OK, 0 = FAIL
    void *task_args;                   // NULL For DEFAULT (NULL)
    void *init_args;                   // NULL For DEFAULT (NULL)
    osPriority priority;
//    uint32_t stack_size;               // 0 for DEFAULT (DEFAULT_STACK_SIZE)
//    unsigned char *stack_pointer;      // NULL for DEFAULT (NULL)
    uint32_t delay;                    // Delay on start from previous task
    Thread *thread;                    // To be filled in during runtime
    uint32_t retVal;                   // Return Value - to be filled in during runtime
};

extern Mutex mutexPCComm;
extern Serial pc;
extern Mutex mutexData;
extern SensorData data;
extern task_definition_struct taskList[];
extern volatile bool sensors_running;
extern uint32_t initTasks(void);

int publishSensorData(void);

#endif
