/*
 * Light sensor operations
 */
#include "mbed.h"
#include "rtos.h"
#include "main.h"
#include "light_sensor.h"

AnalogIn LDR(A5);

uint32_t light_init(void const *args)
{
    return 1;
}
void light_thread(void const *args)
{
//DEBUG
    mutexPCComm.lock();
    pc.printf("LDR: thread init\n");
    mutexPCComm.unlock();
    float lightCurr;
    int8_t error = 0;
    int8_t attempts=0;
    while(true) {
        Thread::signal_wait(0x1);
        mutexPCComm.lock();
        pc.printf("LDR: loop\n");
        mutexPCComm.unlock();
        error = -1;
        attempts=0;
        while(error!=0 && attempts<MAX_READ_ATTEMPTS_LIGHT && sensors_running == true) {
            lightCurr=LDR.read();
            error = 0;
            if(error==0) {
                mutexData.lock();
                data.light = lightCurr;
                data.lightError = 0;
                mutexData.unlock();
            } else {
                mutexData.lock();
                data.lightError = 0;
                mutexData.unlock();
                attempts++;
                Thread::wait(3000);
            }
        } // while read attempts
    } // main thread while
} // thread function
