

#include "draw.h"
#include "main.h"
#include "mbed.h"


Serial command(USBTX, USBRX);


uint8_t buffer_cmd[BUFF_SIZE]={0,0,0,0};




void print_num(uint8_t val) {
    if (val <10)
        command.putc(val+0x30);
    else 
        command.putc(val-9+0x40);
       
}

void print_bin2hex (uint8_t val)
{
    command.printf(" 0x");
    print_num(val>>4);
    print_num(val&0x0f);        
}


void Read_command()
{
// TODO : TIMEOUT UART SERIAL
    for (uint8_t i=0; i<BUFF_SIZE;i++)
        buffer_cmd[i]=command.getc();   
}

void echo_command()
{
    for (uint8_t i=0; i<BUFF_SIZE;i++)
        print_bin2hex(buffer_cmd[i]);
      
}


bool check_command()
{
       if (buffer_cmd[BUFF_SIZE-1]== '>')
             return 1;
        return 0;             
}


void command_led(){
    uint16_t sec = buffer_cmd[TIME_LED_S1];
    sec = (sec <<8) + buffer_cmd[TIME_LED_S0];
    uint16_t msec = buffer_cmd[TIME_LED_mS1];
    msec = (msec <<8) + buffer_cmd[TIME_LED_mS0];
    #if DEBUG
        command.printf("LED ON:   %i segundos y %i milisegundos\n", sec, msec);
    #endif
    led_on(sec,msec);
    
    
}
void command_dot(){
    uint8_t x=buffer_cmd[DOT_POS_X];
    uint8_t y=buffer_cmd[DOT_POS_Y];
    
    #if DEBUG
        command.printf("draw dot: Coord X= %i y Coord Y = %i\n", x,y);
    #endif
    vertex2d(x,y);
    draw();
    nodraw();
    
    }
void command_line(){
      uint8_t xi=buffer_cmd[LINE_POS_Xi];
      uint8_t xf=buffer_cmd[LINE_POS_Xf];
      uint8_t yi=buffer_cmd[LINE_POS_Yi];
      uint8_t yf=buffer_cmd[LINE_POS_Yf];
    
    #if DEBUG
        command.printf("draw line: ");
        command.printf("Coord Xi= %i Coord Yi = %i Coord Xf= %i Coord Yf = %i\n", xi,yi,xf,yf);
    #endif
    line( xi,  yi, xf,  yf);
    
 } 
    
void command_rectangle(){
      uint8_t x=buffer_cmd[REC_POS_X];
      uint8_t y=buffer_cmd[REC_POS_Y];
      uint8_t width=buffer_cmd[REC_WIDTH];
      uint8_t height=buffer_cmd[REC_HEIGHT ];
    
    #if DEBUG
        command.printf("draw rectangle: ");
        command.printf("Coord X= %i  Coord Y = %i width = %i  height= %i\n", x,y,width,height);
    #endif
    rectangle( x,  y,  width,  height);
    }
void command_cicle(){
      uint8_t x=buffer_cmd[CICLE_POS_X];
      uint8_t y=buffer_cmd[CICLE_POS_Y];
      uint8_t r=buffer_cmd[CICLE_POS_R];
#if DEBUG
        command.printf("draw cicle: ");
        command.printf("Centro X= %i  Centro Y = %i radio= %i \n", x,y,r);
    #endif
    circle(x,y,r);
}
void command_home(){
#if DEBUG
        command.printf("pos home ");
    #endif
    home();
}
void command_rstepservo(){
     #if DEBUG
        command.printf("config  rstepservo: ");
    #endif
     }
void command_sstime(){
     #if DEBUG
        command.printf("config tiempo entre movimientos de los servos: ");
        command.printf("SSTIME = %i\n", buffer_cmd[POS_1]);
    #endif
    put_sstime(buffer_cmd[POS_1]);
     }    
void command_stop(){
     #if DEBUG
        command.printf("stop");
    #endif
     }
void command_pause(){
     #if DEBUG
        command.printf("piccolo en pausa ");
    #endif
     }
void command_reanudar(){
     #if DEBUG
        command.printf("reanuda piccolo ");
    #endif
     }
void command_stepmotor(){
     #if DEBUG
        command.printf("comando mover piccolo: ");
    #endif
     }
      
void command_exe()
{
    #if DEBUG
        command.printf("Ejecutando comando: \n");
    #endif
   
    switch (buffer_cmd[COMM_N]){
    case COMMAND_LED :        command_led();  break;
    case COMMAND_DOT :        command_dot();  break;
    case COMMAND_LINE:        command_line(); break;
    case COMMAND_RECTANGLE:   command_rectangle(); break;
    case COMMAND_CICLE:       command_cicle(); break;
    case COMMAND_HOME:        command_home(); break;
    case COMMAND_RSTEPSERVO:  command_rstepservo(); break;
    case COMMAND_SS_TIME:     command_sstime(); break;     
    case COMMAND_STOP :       command_stop(); break; 
    case COMMAND_PAUSA:       command_pause(); break;  
    case COMMAND_REANUDAR:    command_reanudar(); break; 
    case MOVER_STEPMOTOR:     command_stepmotor(); break; 
    default:   
        #if DEBUG
        command.printf("comando  no encontrado\n");
        #endif
    }
}



int main() {
    #if DEBUG
    command.printf("inicio con debug\n");
    #else
    command.printf("inicio sin debug\n");
    #endif
    uint8_t val;
    while(1){
        val=command.getc();
        if (val== '<'){
            Read_command();
            if (check_command()){
                command_exe();
            }else{
                #if DEBUG
                    command.printf("\n ERROR COMANDO -> ");
                    echo_command();
                    command.printf("\n");
                #endif
            }        
        }else{
                #if DEBUG
                 command.printf("error de inicio de trama: ");
                 command.putc(val);
                #endif
        }
        
    }
}

