#include "mbed.h"
#define MAXPOS 50
#define SS_TIME 500
 
PwmOut myServoX(PB_3);
PwmOut myServoY(PB_4);
PwmOut myServoZ(PB_5);
 
 
int coord2us(float coord)
{
    if(0 <= coord <= MAXPOS)
        return int(750+coord*1900/50);// u6
    return 750;
 
}
 
void vertex2d(float x, float y){
 
    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    
    myServoX.pulsewidth_us(pulseX);
    myServoY.pulsewidth_us(pulseY);
    wait_ms(SS_TIME);
 
}
void home()
{
vertex2d(0 ,0);
}    
 
void maxpos()
{
vertex2d(MAXPOS ,MAXPOS);
}    
 
void diag()
{
    
    vertex2d(0,0);
    vertex2d(10,10);
    vertex2d(20,20);
    vertex2d(30,30);
    wait(2);vertex2d(40,40);   
    wait(2);vertex2d(50,50);   
    
    }
    
void line (){     

        int xi, yi,xf,yf;
        int p= 5;
        int y=yi;
        float k, n, x;  
        k=(yf-yi)/p;
        n=(xf-xi)/p;
        
        for (x=xi;x<=xf;x+n){
         
            y = y+k;
            vertex2d(x,y);            
     }
  }  
void square ()
{
      float x, y, l;
      int s,d;
      int k,n;
          for (k=x;k<=l;k+l){
            s=k;
            vertex2d(s,d);
          }
          
          for (n=y;n<=l;k+l){
            d=n;
            vertex2d(s,d);
          }
          
          for (k=l;k>=x;k-l){
            s=k;
            vertex2d(s,d);
          }
          
          for (n=l;n>=y;k-l){
            s=k;
            vertex2d(s,d);
          }
  }        
void circle ()
{
        int x, y, R;
        float xc;
        float yc;
        yc = y;
        xc = x+R;
        int s,d;
        
 
 
            for (yc=y;yc<(y+R);yc++){
                xc= sqrt((R*R)-(yc*yc));
                vertex2d(s,d);
          }
            for (xc=x; xc>(x-R); xc--){
                yc= sqrt((R*R)-(xc*xc));
                vertex2d(s,d);
          }
            for (yc=y; yc>(x-R); yc--){
                yc= sqrt((R*R)-(yc*yc));
                vertex2d(s,d);
          }
            for (xc=x; xc<(x-R); xc++){
                xc= sqrt((R*R)-(xc*xc));
                vertex2d(s,d);
          }
    }        
int main() {
     // configuracion de  periodo
    myServoX.period_ms(20);
    myServoY.period_ms(20);
    myServoZ.period_ms(20);
    
    
    while(1)
    {
  
     home();
     wait(3);
     maxpos();    
     wait(3);
     diag();
     wait(3);
     line();
     wait(3);
     square();
     wait(3); 
     circle();
     wait(3);
     }
 }

 
