/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
//#include "platform/mbed_thread.h"
#include "hcsr04.h"

DigitalOut myled(LED1);
Serial pc(USBTX,USBRX);
HCSR04  usensor(D8, D9);
unsigned int dist;
DigitalOut GREEN(D7); 
DigitalOut BLUE(LED3);  
Timer dt;


#include "MFRC522.h" 
// FRDM-K64F (Freescale) Pin for MFRC522 reset 
#define MF_RESET    PTD0 
#define SERIAL_1

DigitalOut LedGreen(LED2); 

//Serial connection to PC for output 
//Serial pc(PTC17, PTC16); // serial comm on the FRDM board

//wireless bluetooth connection to Android Device for output
Serial blue(PTC15, PTC14);   

 
//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET); 
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0); 
 
int counter1 = 0;
int counter2 = 0; 
 


// Blinking rate in milliseconds
//#define BLINKING_RATE_MS 500


int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);

    /*while (true) {
        led = !led;
        //thread_sleep_for(BLINKING_RATE_MS);
    }*/
    BLUE=1;
    pc.baud(9600);
    dt.start(); 
    while(1) {
        usensor.start();
        wait_ms(500); 
        dist=usensor.get_dist_cm();
        pc.printf("\n\r cm:%ld",dist);
        
            printf("Welcome to RFID Tag Reader Using FRDM K64F...\n\r");
   blue.printf("Welcome to RFID Tag Reader Uing FRDM K64F...\n\r");
   printf("Bluetooth Enable\r\n");
   blue.printf("Bluetooth Enable\r\n");
   RfChip.PCD_Init(); 
 
    
     LedGreen = 1; 
 
     // Look for new cards 
     if ( ! RfChip.PICC_IsNewCardPresent()) 
     { 
       if (dist>20)
        {
         GREEN = !GREEN;
        }
        else
        {
            BLUE=0;
            continue;
        } 
     } 
 
     // Select one of the cards 
     if ( ! RfChip.PICC_ReadCardSerial()) 
     { 
       if (dist>20)
        {
         GREEN = !GREEN;
        }
        else
        {
            BLUE=0;
            continue;
        } 
     } 
      LedGreen = 0;
      int a=0; 
 
     // Print Card UID 
     printf("Card UID:"); 
     blue.printf("Card UID:");
     for (uint8_t i = 0; i < RfChip.uid.size; i++) 
     { 
      printf(" %X02 ", RfChip.uid.uidByte[i]);
      blue.printf(" %X02 ", RfChip.uid.uidByte[i]);
      a = RfChip.uid.uidByte[0];
     }  
     printf("%d",a);
     
     //Print Card Type
    if(a==73)
    { 
    if(counter1 == 0){
         printf("\r\nMilk is in the fridge");
         blue.printf("\r\nWhite Card");
         counter1 = 1;
     }
     else if(counter1 == 1){
         printf("\r\nMilk is out of the fridge");
         counter1 = 0;
         }
     }
    
     if(a==207)
     {
    if (counter2 == 0)
    {
    printf("\r\nBeer is in the fridge");
    blue.printf("\r\nBlue Keychain");
    counter2 = 1;
    }
    else if (counter2 == 1){
    printf("\r\nBeer is out of the fridge");
    counter2 = 0;
    }
    }
    //wait(1);
     printf("\n\r"); 
     blue.printf("\n\r"); 
   
         printf("\r\nParcel taken");
         blue.printf("\r\nParcel taken");
        
     printf("\n\r"); 
     blue.printf("\n\r"); 
     
     // Print RFID Card type 
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak); 
     printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     blue.printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));  
   break;
   }
     
      blue.baud(9600);
   pc.baud(9600);
    }
  



