#include "mbed.h"
#include "USBSerial.h"
#include <stdlib.h>
#include "MMA845x.h"

//Virtual serial port over USB
USBSerial serial;

//accelerometer
PinName const SDA = P0_5;
PinName const SCL = P0_4;
PinName const INT1 = P0_20;
PinName const INT2 = P0_2;
#define MMA8451_I2C_ADDRESS (0x1C << 1)

MMA845x acc(SDA, SCL, MMA8451_I2C_ADDRESS, INT1, INT2 );

//Struct to represent the neighbors of an led
//stored clockwise, starting up side
struct circuit
{
    int up;
    int right;
    int down;
    int left;
};
struct circuit layout[] = {{-1,-1, 1,-1},  // LED 0
                           { 0, 3, 2,-1},  // LED 1
                           { 1,-1,-1,-1},  // LED 2
                           {-1, 5,-1, 1},  // LED 3
                           {-1, 7, 5,-1},  // LED 4
                           { 4, 8, 6, 3},  // LED 5
                           { 5, 9,-1,-1},  // LED 6
                           {-1,-1, 8, 4},  // LED 7 , LED0 rigth
                           { 7,10, 9, 5},  // LED 8
                           { 8,-1,-1, 6},  // LED 9
                           {-1,12,-1, 8},  // LED 10
                           {-1,-1,12,-1},  // LED 11
                           {11,-1,13,10},  // LED 12
                           {12,-1,-1,-1},  // LED 13
                          }; 
 
DigitalOut LEDs[] = {(P0_19), (P0_18), (P0_17), (P1_15), (P0_23), (P0_14), (P0_15),
                     (P0_9), (P0_8), (P0_7), (P0_21), (P0_10), (P0_22), (P0_11)
                    };// declare 10 LEDs
    
DigitalOut Buzzer(P0_13);

//catch the blinking LED
volatile int destLed = 13;
void blink()
{
    LEDs[destLed] = !LEDs[destLed];
}

void change_dest()
{
    int new_dest ;
    do {
        new_dest = rand() % 14 ;
        }
    while ( LEDs[new_dest] );
    
    LEDs[destLed] = false;
    destLed = new_dest;
}                      
                           
main()
{
    srand((unsigned)(acc.getX()+acc.getY()));
    change_dest();

    int X1;
    int Y1;
    int Z1;
    
    int i;
     
    Ticker blink_timer;
    blink_timer.attach(&blink,0.15);
    
    Ticker dest_timer;
    dest_timer.attach(&change_dest,1.0);

    for (i=0;i<14;i++)
    {
        LEDs[i] = false;
        i++;
    }
    Buzzer = false;
    
    int activeLED = 0;
    int nextLED = -1;
    LEDs[activeLED] = true;
    int speed = 300;
    int speedfactor = 4;
 
    i = 0;
    do {
        i++;         
        
        X1=0;
        Y1=0;
        Z1=0;
        
        for(int j=1;j<10;j++) {
            X1 += acc.getX();
            Y1 += acc.getY();
            Z1 += acc.getZ();
            };
             
        X1 /= 10;
        Y1 /= 10;
        Z1 /= 10;
        
 /*     double c = sqrt( pow((double) X1,2.0)+pow((double) Y1,2.0)+pow((double) Z1,2.0)  );

        serial.printf("Nr : %d \n",i);
        serial.printf("X-Axis: %d \n",X1);
        serial.printf("Y-Axis: %d \n",Y1);
        serial.printf("Z-Axis: %d \n",Z1);
        serial.printf("G: %f \n",c);   */
        
        nextLED = -1;
        if ((abs(X1)>10) or (abs(Y1)>10)) {
            if (abs(X1) > abs(Y1)) {
                speed = 300 - abs(X1);
                if (X1 > 0 ) nextLED = layout[activeLED].right ;
                else nextLED = layout[activeLED].left;
                }
            else {
                speed = 300 - abs(Y1);
                if (Y1 < 0 ) nextLED = layout[activeLED].up ;
                else nextLED = layout[activeLED].down;
            };
            if (nextLED > -1) {
                LEDs[activeLED]= false;
                activeLED = nextLED;
                LEDs[activeLED]= true;
                 
                if ( speed < 150 ) speed=150;
                wait_ms(speed/speedfactor);
                Buzzer = false;
            }
            else  {
                for (int j=0;j<128;j++) {
                    Buzzer = !Buzzer ;
                    wait_ms(speed/(speedfactor*32));
                }
            }
        }
        else {
            speed=300;
            wait_ms(speed/speedfactor);
        }; 
                           
    }
    while (activeLED != destLed);
    dest_timer.detach();
    blink_timer.detach();
    destLed = activeLED;
    blink_timer.attach(&blink,0.1);
    
    for (int j=0;j<50;j++) {
        Buzzer = !Buzzer ;
        wait_ms(50);
    }
    blink_timer.detach();
    LEDs[activeLED] = false;    
    deepsleep();    
}

