/* Copyright (c) 2014 GHI Electronics, LLC
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
/*edit by VBDaniel ...to by continued*/


#ifndef MMA845X_H
#define MMA845X_H

#include "mbed.h"

class MMA845x
{
public:
 //   MMA845x(PinName sda, PinName scl, int i2cAddress);
    MMA845x(PinName sda, PinName scl, int i2cAddress, PinName int1, PinName int2);
    ~MMA845x();

    int16_t getX();
    int16_t getY();
    int16_t getZ();
    void GetXYZ(int& x, int& y, int& z);
  
    struct AccelerationAxes
    {
        int x;
        int y;
        int z;
    };

private:
    I2C i2cBus;    
    InterruptIn int1;
    InterruptIn int2;
    int i2cAddress;
    void readRegister(uint8_t registerAddress, uint8_t* data, int length);
    int16_t readAxisRegister(uint8_t axisRegisterAddress);
    void writeRegister(uint8_t * data, int length);
    //int16_t getAccAxis(uint8_t address);

};

#endif
