/* Copyright (c) 2014 GHI Electronics, LLC
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
/*edit by VBDaniel ...to by continued*/

#include "MMA845x.h"

#define X_AXIS  0x01
#define Y_AXIS  0x03
#define Z_AXIS  0x05
#define SYSMOD  0x0B    // System Mode Register (Read Only)
#define CRTL_REG1 0X2A  // ODR = 800 Hz, STANDBY Mode.
#define CTRL_REG2 0x2B  // Sleep Enable, OS Modes, RST, ST
#define CTRL_REG3 0x2C  // Wake from Sleep, IPOL, PP_OD
#define CTRL_REG4 0x2D  // Interrupt enable register
#define CTRL_REG5 0x2E  // Interrupt pin (INT1/INT2) map

enum SYSMOD_BITS
{
    SYSMOD0 ,
    SYSMOD1 ,
    /*  SYSMOD[1:0]
        System Mode. Default value: 00.
        00: STANDBY mode
        01: WAKE mode
        10: SLEEP mode
    */
    FGT_1 ,
    FGT_2 ,
    FGT_3 ,
    FGT_4 ,
    FGERR ,
};


MMA845x::MMA845x(PinName sda, PinName scl, int i2cAddress, PinName intPin1, PinName intPin2) : i2cBus(sda, scl), i2cAddress(i2cAddress), int1(intPin1), int2(intPin2)
{
    uint8_t initializeDataCommand[2] = {0x2A, 0x01};
    i2cBus.write(i2cAddress, (char*)initializeDataCommand, 2);
}


MMA845x::~MMA845x()
{
}

int16_t MMA845x::getX()
{
    return readAxisRegister(X_AXIS);
}

int16_t MMA845x::getY()
{
    return readAxisRegister(Y_AXIS);
}

int16_t MMA845x::getZ()
{
    return readAxisRegister(Z_AXIS);
}

void MMA845x::GetXYZ(int& x, int& y, int& z)
{
}

int16_t MMA845x::readAxisRegister(uint8_t axisRegisterAddress)
{
    uint8_t axisData[2];
    readRegister(axisRegisterAddress, axisData, 2);
    
    int16_t rawAxisData = ((axisData[0] << 2) | (axisData[1] >> 6));
    
    if (rawAxisData > 511)
        rawAxisData = rawAxisData - 1024;
        
    return rawAxisData;
}

void MMA845x::readRegister(uint8_t registerAddress, uint8_t* data, int length)
{
    char convertedRegisterAddress[] = {registerAddress};
    i2cBus.write(i2cAddress, convertedRegisterAddress, 1, true);
    i2cBus.read(i2cAddress, (char*)data, length);
}


void MMA845x::writeRegister(uint8_t* data, int length)
{
}
