#include "PrjDefs.h"

void InitRects(){
    R_T(&TempR_Rect);
    sprintf((char*)TempS_Rect.s, "Ttg=%3.0fC", TempS);
    R_T(&TempS_Rect);
    sprintf((char*)dTdt_Rect.s, "dTdt%1.2f", dTdt);
    R_T(&dTdt_Rect);
    sprintf((char*)Extra_Rect.s, "KP=%1.3f", KProp);
    sprintf((char*)Extra_Rect.s, "PL=%1.3f", PWM);
    R_T(&Extra_Rect);
    R_T(&Start_Rect);
    R_T(&Plus_Rect);
    R_T(&Minus_Rect); 
    R_T(&SelExtra_Rect);
    }//InitRects

void InitLCDandTS() {
    BSP_LCD_SetFont(&Font24);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    uint8_t status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK){
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
        wait(1);
        }else{
            lcd.Clear(LCD_COLOR_GREEN);
            lcd.SetBackColor(LCD_COLOR_GREEN);
            lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
            wait(0.5);
            }
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
}//InitLCDandTS

void R_T(RT_Pars *rp){
    uint32_t _c = lcd.GetTextColor();
    uint32_t _b = lcd.GetBackColor();
    lcd.SetTextColor(rp->cr);
    lcd.FillRect(rp->xr, rp->yr, rp->wr, rp->hr);
    lcd.SetBackColor(rp->cr);
    lcd.SetTextColor(rp->ct);
    lcd.DisplayStringAt(((rp->xr)+(rp->xt)), ((rp->yr)+(rp->yt)), &(rp->s[0]), LEFT_MODE);
//    lcd.SetBackColor(_b);
//    lcd.SetTextColor(_c);
    }//R_T