#include "PrjDefs.h"

DigitalOut xx(PG_13);
//Ticker Tick;

float dTprev = 0;
float IntPart = 0;
float PL = 0;
float Power = 0;
float RefT = 0;
bool Expired;
bool Down;

void ResetPID(){
    dTprev = 0;
    IntPart = 0;
    PL = 0;
    Power = 0;
    }//ResetPID
    
float GetRefT(float r){
    if (Expired) return TempS;
    float _f = r;
    if(Start){
        if(Down) _f -= dTdt * 0.1;
        else _f += dTdt * 0.1;
        }
    else _f = 0;
    if(Down && (_f<=TempS)) { Expired = 1; return TempS; } 
    else if((!Down) && (_f>=TempS)){ Expired = 1; return TempS; }
    else return _f; 
    }//GetRefT

void ReStartH(){
    RefT = cT;
    Expired = 0;
    if(cT<=TempS) Down =0;
    else Down = 1;
    }//StartH        
    
void Start_H(){
    ReStartH();
    Start = 1;
    }//StartH        
    
void StopH(){
    RefT = 0;
    Expired = 0;
    Down = 0;
    Start = 0;
    ResetPID();
    PWM = 0;
    }//StopH        
    
void PID(){
    float _f = dT * KProp / 10.0;
    Power = _f;
    LoUpLimit(Power, 0, MaxPower);
    IntPart += (dT * KInt / 100.0);
    LoUpLimit(IntPart, 0, MaxPower);
    Power += IntPart;
    _f = -(KDif * (dT - dTprev) / 10.0);
    LoUpLimit(_f, 0, MaxPower);
    Power += _f;
    LoUpLimit(Power, 0, MaxPower);
    PWM = Power;
    dTprev = dT;
    }//PID

void RxMsgThrdFunc(){
MsgType _msg;
MsgType *_mail;
TxRxServiceInit();
while (1) {
    TxRxStates _trs = GetMsg(&_msg.cmd);
    if(_trs == RxRcvd){
        cT = _msg.pars.f[0];
        if(Start){
            RefT = GetRefT(RefT);
            dT = RefT - cT;
            xx=1;
            PID();
            xx=0;
            _mail = MsgMail.alloc();
            if(ExtraSelected == PWM_Selected) _mail->cmd = PWM_Selected;
            else if(ExtraSelected == PWM_Changing) _mail->cmd = PWM_Changing;
            else _mail->cmd = PrjEventNone;
            _mail->pars.f[0] = PWM;
            MsgMail.put(_mail);
                
            _mail = MsgMail.alloc();
            if(TempR_Selected == cT_Selected){
                _mail->cmd = cT_Selected;
                _mail->pars.f[0] = cT;
                }else{
                    _mail->cmd = dT_Selected;
                    _mail->pars.f[0] = dT;
                    }
            MsgMail.put(_mail);
            }else{//if(Start)
                PWM = 0;
                ResetPID();
                _mail = MsgMail.alloc();
                _mail->cmd = cT_Selected;
                _mail->pars.f[0] = cT;
                MsgMail.put(_mail);
                }//else{//if(Start)
        
        
        
        _msg.cmd = CmdPWM;
        _msg.pars.f[0] =  PWM;
        SendMsg(&_msg.cmd);
        
        }//if(_trs == RxRcvd)
    ThisThread::sleep_for(1);
    }//while(1)
}//RxMsgThrdFunc