#ifndef PrjDefs_h_active
#define PrjDefs_h_active

#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include "TS_DISCO_F429ZI.h"
#include "rtos.h"

//#define ParsLength (insert needed ParsLength here) // по умолчанию 4
#define BaudRate 115200                 // по умолчанию 9600
//#define WorkTx (insert TxPin name here) // по умолчанию PA_9, PD_8 или USBTX (зависит от платы)
//#define WorkRx (insert RxPin name here) // по умолчанию PA_10, PD_9 или USBRX (зависит от платы)
//#define UsedSerialClass Serial          // по умолчанию RawSerial
#include "TxRxService.h"

enum PrjEventCodes {
    PrjEventNone,
    Cmd_cT = 0x16,
    CmdPWM,
//    CmdTempS,
//    Cmd_dTdt,
    CmdExtra,
    CmdStart,
    CmdStop,
    CmdPlus,
    CmdMinus,
    CmdExtraPars,
    CmdSelExtraPars,
    cT_Selected,
    dT_Selected,
    TempS_Selected,
    TempS_Changing,
    dTdt_Selected,
    dTdt_Changing,
    ChangingParamNone,
    KP_Changing,
    KI_Changing,
    KD_Changing,
    PWM_Changing,
    KP_Selected,
    KI_Selected,
    KD_Selected,
    PWM_Selected,
    PrjEventCodesUndef};
    
enum ChangingParamNums {
    ChangingParamNumsUndef};
    
typedef struct {
    uint16_t xr;
    uint16_t yr;
    uint16_t wr;
    uint16_t hr;
    uint32_t cr;
    uint16_t xt;
    uint16_t yt;
    uint32_t ct;
    uint8_t s[10] = "---";
    uint8_t gap = 2;
    uint32_t cx = LCD_COLOR_LIGHTGRAY;
    } RT_Pars;

extern bool Start;
extern uint8_t ChangingParam;
extern uint8_t ExtraSelected;
extern uint8_t TempR_Selected;
extern float TempS;
extern float dTdt;
extern float cT;
extern float dT;
extern float KProp;
extern float KInt;
extern float KDif;
extern float PWM;


extern RT_Pars TempR_Rect;
extern RT_Pars TempS_Rect;
extern RT_Pars dTdt_Rect;
extern RT_Pars Extra_Rect;
extern RT_Pars Start_Rect;
extern RT_Pars Plus_Rect;
extern RT_Pars Minus_Rect;
extern RT_Pars SelExtra_Rect;

extern void InitLCDandTS();
extern void R_T(RT_Pars *rp);
extern bool HitTest(RT_Pars *rp,uint16_t x,uint16_t y);
extern void RxMsgThrdFunc();
extern void TouchScreenThrdFunc();
extern void InitRects();
extern void ReStartH();
extern void Start_H();        
extern void StopH();        
    


#define MailLength 30

extern Mail<MsgType, MailLength> MsgMail;
extern Thread RxMsgThrd;
extern Thread TouchScreenThrd;
extern Thread TouchScreenThrd;
extern LCD_DISCO_F429ZI lcd;
extern TS_DISCO_F429ZI ts;

#define LowerLimit(Value,Min) if(Value < Min) Value = Min;
#define UpperLimit(Value,Max) if(Value > Max) Value = Max;
#define LoUpLimit(Value,Min,Max) LowerLimit(Value,Min) UpperLimit(Value,Max)

#define MaxPower 1
#define MinPower 0
#define MaxKProp 1
#define KPropStep 0.001
#define MaxKInt 1
#define KIntStep 0.001
#define MaxKDif 1
#define KDifStep 0.001
#define MaxPWM 1
#define PWM_Step 0.01
#define dTdtStep 0.01
#define Max_dTdt 2
#define MaxTempS 150
#define DefaultRectColor LCD_COLOR_LIGHTGRAY
#define ChangingRectColor LCD_COLOR_YELLOW
#define DefaultTextColor LCD_COLOR_WHITE
#define ChangingTextColor LCD_COLOR_BLACK

#define ScreenWidth 240
#define ScreenHeight 320
#define DefaultRectHeight 75
#define DefaultSpace 4
#define DefaultRightRectWidth DefaultRectHeight
#define DefaultLeftRectXpos DefaultSpace
#define DefaultRightRectXpos (ScreenWidth - DefaultRightRectWidth - DefaultSpace)
#define DefaultLeftRectWidth (ScreenWidth - DefaultRightRectWidth - 3*DefaultSpace)

#define Default1stRowRectYpos DefaultSpace
#define Default2ndRowRectYpos (DefaultSpace*2 + DefaultRectHeight)
#define Default3rdRowRectYpos (DefaultSpace*3 + 2*DefaultRectHeight)
#define Default4thRowRectYpos (DefaultSpace*4 + 3*DefaultRectHeight)

#define TextXpos 8
#define TextYpos 28

#endif //#ifndef PrjDefs_h_active