#include "PrjDefs.h"

int main()
{

    MsgType _msg;

    RxMsgThrd.start(RxMsgThrdFunc);
    RxMsgThrd.set_priority(osPriorityHigh);
    
    TouchScreenThrd.start(TouchScreenThrdFunc);
    TouchScreenThrd.set_priority(osPriorityAboveNormal);
  
    InitLCDandTS();
    
    InitRects();
    
    while(1){               
        osEvent evt = MsgMail.get(0);
        if (evt.status == osEventMail) {
            MsgType *mail = (MsgType*)evt.value.p;
            switch ( mail->cmd ){
                case Cmd_cT:{
                    float _f = mail->pars.f[0]; 
//                    sprintf((char*)TempR_Rect.s, "T= 3.1fC");
                    sprintf((char*)TempR_Rect.s, "Tcr=%3.0fC", mail->pars.f[0]);
//                    if( _f >= 100) sprintf((char*)TempR_Rect.s, "T=%3.1fC", cT);
//                    else sprintf((char*)TempR_Rect.s, "T= %2.1fC", cT);
                    R_T(&TempR_Rect);
                    break;}
                case cT_Selected:{
                    float _f = mail->pars.f[0];
                    sprintf((char*)TempR_Rect.s, "Tcr=%3.0fC", mail->pars.f[0]);
//                    if( _f >= 100) sprintf((char*)TempR_Rect.s, "T=%3.1fC", _f);
//                    else sprintf((char*)TempR_Rect.s, "T= %2.1fC", _f);
                    TempR_Rect.cr = DefaultRectColor;
                    TempR_Rect.ct = DefaultTextColor;
                    R_T(&TempR_Rect);
                    break;}//cT_Selected
                case dT_Selected:{
                    float _f = mail->pars.f[0]; 
                    if(_f < 0) _f = -_f; 
                    if(_f>=100) sprintf((char*)TempR_Rect.s, "dT=%+3.f", mail->pars.f[0]);
                    else if(_f>=10) sprintf((char*)TempR_Rect.s, "dT=%+2.1f", mail->pars.f[0]);
                    else sprintf((char*)TempR_Rect.s, "dT=%+1.2f", mail->pars.f[0]);
                    TempR_Rect.cr = LCD_COLOR_LIGHTBLUE;
                    TempR_Rect.ct = ChangingTextColor;
                    R_T(&TempR_Rect);
                    break;}//dT_Selected
                case CmdStart:{
                    if(mail->pars.ui8[0])Start_Rect.cr = LCD_COLOR_RED;
                    else Start_Rect.cr = LCD_COLOR_GREEN;
                    R_T(&Start_Rect);
                    break;}   
                case CmdPWM:{
                    sprintf((char*)dTdt_Rect.s, "P=%1.3f", mail->pars.f[0]);
                    R_T(&dTdt_Rect);
                    break;}
                case KP_Changing:{
                    sprintf((char*)Extra_Rect.s, "KP=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = ChangingRectColor;
                    Extra_Rect.ct = ChangingTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case KP_Changing
                case KI_Changing:{
                    sprintf((char*)Extra_Rect.s, "KI=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = ChangingRectColor;
                    Extra_Rect.ct = ChangingTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case KI_Changing
                case KD_Changing:{
                    sprintf((char*)Extra_Rect.s, "KD=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = ChangingRectColor;
                    Extra_Rect.ct = ChangingTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case KD_Changing
                case PWM_Changing:{
                    sprintf((char*)Extra_Rect.s, "PL=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = ChangingRectColor;
                    Extra_Rect.ct = ChangingTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case PWM_Changing
                case KP_Selected:{
                    sprintf((char*)Extra_Rect.s, "KP=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = DefaultRectColor;
                    Extra_Rect.ct = DefaultTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case KP_Selected
                case KI_Selected:{
                    sprintf((char*)Extra_Rect.s, "KI=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = DefaultRectColor;
                    Extra_Rect.ct = DefaultTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case KI_Selected
                case KD_Selected:{
                    sprintf((char*)Extra_Rect.s, "KD=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = DefaultRectColor;
                    Extra_Rect.ct = DefaultTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case KD_Selected
                case PWM_Selected:{
                    sprintf((char*)Extra_Rect.s, "PL=%1.3f", mail->pars.f[0]);
                    Extra_Rect.cr = DefaultRectColor;
                    Extra_Rect.ct = DefaultTextColor;
                    R_T(&Extra_Rect);                    
                    break;}//case PWM_Selected
                case TempS_Changing:{
                    TempS_Rect.cr = ChangingRectColor;
                    TempS_Rect.ct = ChangingTextColor;
                    sprintf((char*)TempS_Rect.s, "Ttg=%3.0fC", mail->pars.f[0]);
                    R_T(&TempS_Rect);                    
                    break;}//case TempS_Changing
                case TempS_Selected:{
                    TempS_Rect.cr = DefaultRectColor;
                    TempS_Rect.ct = DefaultTextColor;
                    sprintf((char*)TempS_Rect.s, "Ttg=%3.0fC", mail->pars.f[0]);
                    R_T(&TempS_Rect);                    
                    break;}//case TempS_Selected
                case dTdt_Changing:{
                    dTdt_Rect.cr = ChangingRectColor;
                    dTdt_Rect.ct = ChangingTextColor;
                    sprintf((char*)dTdt_Rect.s, "dTdt%1.2f", dTdt);
                    R_T(&dTdt_Rect);
                    break;}//dTdt_Changing
                case dTdt_Selected:{
                    dTdt_Rect.cr = DefaultRectColor;
                    dTdt_Rect.ct = DefaultTextColor;
                    sprintf((char*)dTdt_Rect.s, "dTdt%1.2f", dTdt);
                    R_T(&dTdt_Rect);
                    break;}//dTdt_Selected
                default: break;
                }//switch
            MsgMail.free(mail);
            }//if (evt.status == osEventMail)
            
//        ThisThread::sleep_for(1);
        }//while(1)
}//main

/*
DigitalOut xx(PG_13);//зеленый светодиод LD3 DISCO
        lcd.FillTriangle(45,45,80,142,177,157);
*/