    
#ifndef ParsLength
  #define ParsLength 4
#endif
#if ParsLength>16
  #error The length of the parameters seems to be too long. Maybe You should use a different Protocol.
#elif ParsLength<2
  #error The length of the parameters seems to be meaningless. Maybe You should use a different Protocol.
#endif

#ifndef UsedSerialClass
  #define UsedSerialClass RawSerial
#endif

#define HeaderByte 0x00
#define HeaderLength (ParsLength+1)

// ++++++++ Назначение параметров используемого U(S)ART по умолчанию 
// У F031K6 U(S)ART один, поэтому 
// для F031K6 и для всех неопробованных плат назначается 
// U(S)ART по умолчанию (USBTX,USBRX). 
#ifndef WorkTx 
  #ifdef TARGET_NUCLEO_L432KC
    #define WorkTx PA_9  // USART1
  #elif defined TARGET_NUCLEO_F072RB
    #define WorkTx PA_9  // USART1
  #elif defined TARGET_DISCO_F429ZI
    #define WorkTx PG_14  // USART6; USART1(PA_9,PA_10) используется для терминала
  #elif defined TARGET_NUCLEO_F031K6
    #define WorkTx USBTX
  #else
    #define WorkTx USBTX
  #endif
#endif
#ifndef WorkRx
  #ifdef TARGET_NUCLEO_L432KC
    #define WorkRx PA_10 // USART1
  #elif defined TARGET_NUCLEO_F072RB
    #define WorkRx PA_10 // USART1
  #elif defined TARGET_DISCO_F429ZI
    #define WorkRx PG_9  // USART6; USART1(PA_9,PA_10) используется для терминала
  #elif defined TARGET_NUCLEO_F031K6
    #define WorkRx USBRX
  #else
    #define WorkRx USBRX
  #endif
#endif
// Назначение выводов используемого U(S)ART по умолчанию --------


#pragma pack(push, 1)//https://os.mbed.com/forum/bugs-suggestions/topic/4264/  проблема выравнивания данных
typedef union {
    uint8_t ui8[ParsLength];
    int8_t i8[ParsLength];
    uint16_t ui16[ParsLength/2];
    int16_t i16[ParsLength/2];
#if ParsLength>=4
    uint32_t ui32[ParsLength/4];
    int32_t i32[ParsLength/4];
    float f[ParsLength/4];
#endif
    } ParsType;
  
typedef struct {
    uint8_t cmd;
    ParsType pars;
    uint8_t cs;
    } MsgType;
#pragma pack(pop)

#define ArrTxSize (HeaderLength + sizeof(MsgType))
#define ArrRxSize (HeaderLength + sizeof(MsgType))

enum TxRxStates {
    TxOK,
    TxBuffBusy,
    RxBuffEmpty,
    RxRcvd,
    RxCS_Err,
    Undefined
    };

#define ArrTxInitializer {HeaderByte,HeaderByte,HeaderByte,HeaderByte,HeaderByte}

extern void TxRxServiceInit();
extern TxRxStates SendMsg(uint8_t *parr);
extern TxRxStates GetMsg(uint8_t *parr);
 