#include "PrjDefs.h"

DigitalOut myled(LED1);

#ifndef TARGET_NUCLEO_L432KC
InterruptIn Butt(USER_BUTTON);
#endif

Serial dpc(USBTX,USBRX);

Ticker tickTx;

MsgType _msg;

bool tick = 0;
uint32_t ctr = 0;  // счетчик обменов
uint32_t ctro = 0; 
uint32_t Ectr = 0; // счетчик ошибок

void dpc_func(){ (void)dpc.getc(); SendMsg(&_msg.cmd); }

#ifndef TARGET_NUCLEO_L432KC
void ButtPrsd(){ SendMsg(&_msg.cmd); }
#endif

void tickIntrFunc(void){ tick = 1; }//tickIntrFunc

int main() {
    
    _msg.cmd=0x41;
    _msg.pars.ui32[0]=0;
    
    TxRxServiceInit();
    tickTx.attach(&tickIntrFunc, 1);
    dpc.baud(115200);
    dpc.attach(dpc_func);
    
#ifndef TARGET_NUCLEO_L432KC
    Butt.fall(&ButtPrsd);
#endif
    
            //Exige Monumentum
            //Я дебил,потому что хотел выполнить действия,которые
            //требуются постоянно,один раз и именно здесь.
            
            //Для дебилов: в mbed типы "int" и "unsigned int" имеют размер 4 байта !!!
            
            //https://os.mbed.com/forum/bugs-suggestions/topic/4264/   проблема выравнивания данных
    
    while(1) {
        TxRxStates _trs = GetMsg(&_msg.cmd);
        if(_trs == RxRcvd){
            myled = !myled;
            ctr++; 
            _msg.pars.ui32[0]++;
            if(tick){
                tick = 0;
                dpc.printf("ctr = %d, diff = %d, Ectr = %d\n\r", ctr, ctr - ctro, Ectr); 
                ctro = ctr;
                }
            SendMsg(&_msg.cmd);
            }else if(_trs == RxCS_Err) Ectr++;
        }//while(1)
}//main

