#include "mbed.h"
#include "ESP8266.h"
#include "TCPSocketConnection.h"
#include <string>
#include <stdio.h>
#include <stdlib.h>
using namespace std;

DigitalIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
ESP8266 wifi(PA_9,PA_10,D3,115200);
Serial pc(SERIAL_TX, SERIAL_RX);
TCPSocketConnection gm;
AnalogIn Current(A0);
AnalogIn Voltage(A1);


char* generatePostRequest(float current, float voltage)
{
    char post[] = "GET /update?key=";
    char ThingSpeak_key[] = "3BCEJZ4D93E63PNN";
    char current_field[] = "&field1=";
    char voltage_field[] = "&field2=";
    char coordinates[] = "";
    char status[] = "";
    char msg[75] = "";
    
    sprintf(msg, "%s%s%s%f%s%f%s%s\r\n\r\n", post, ThingSpeak_key, current_field, current, voltage_field, voltage, coordinates, status);

    return msg;
}

int main()
{
    pc.baud(115200);
    
    int init_flag=0;
    float sum_current = 0.0;
    float sum_voltage = 0.0;
    float I = 0.0;
    float V = 0.0;
    
    while(1) {
        if(init_flag==0) {
hardwareInit:
            pc.printf("intializing hardware,...\r\n");
            if(wifi.init()) {
                pc.printf("hardware intialized!\r\n");
                init_flag = 1;
nustConnection:
                pc.printf("connecting to NUST,...\r\n");
                if(wifi.connect("NUST","nust008tech")) {

                    pc.printf("NUST Connected!\r\n");
                    if(wifi.is_connected()) {
                        pc.printf("connection confirmed!\r\n");
                        pc.printf("IP Adress: %s\r\n",wifi.getIPAddress());
hostConnection:
                        pc.printf("connecting to Host,...\r\n");
                        while(1)
                        {
                        sum_current = 0.0;
                        sum_voltage = 0.0;    
                            
                        if(gm.connect("184.106.153.149",80)==0) {
                            pc.printf("Host connected.\r\n");
                            /////////////////////////////////////////////////////////////////////////////////
                            for (int i = 0; i < 100; i++)
                            {
                                sum_current += Current.read();
                                sum_voltage += Voltage.read();
                                wait_us(50);
                            }
                            I = sum_current/100;
                            V = sum_voltage/100;
                            
                            I = (I-0.5)*3.3/0.185;
                            V = V;
                            
                            pc.printf("%.4f\n\r", I);
                            
                            char* getRequest = generatePostRequest(I, V);
                            /////////////////////////////////////////////////////////////////////////////////
sendGETRequest:
                            pc.printf("sending GET request,...\r\n");
                            if(gm.send_all(getRequest,strlen(getRequest))>0) {
                                pc.printf("GOT!\r\n");

                                char getResponce[5000]= {};
                                pc.printf("reading responce of GET request!\r\n");
                                int resBytes = gm.receive_all(getResponce,5000);
                                if(resBytes > 0) {
                                    pc.printf("Responce Received!\r\n");
                                    pc.printf("Responce:\r\n%s\r\nResponce Read Sucessfull.\r\n",getResponce);
                                } else if(resBytes==0) {
                                    pc.printf("Empty Responce!\r\n");
                                    //goto sendGETRequest;
                                } else {
                                    pc.printf("Resopnce NOT Received!\r\n");
                                    goto sendGETRequest;
                                }

                            } else {
                                pc.printf("GET request failed!\r\n");
                                goto sendGETRequest;
                            }
                        }else {
                            pc.printf("Host Connection Failed\r\n");
                            goto hostConnection;
                        }
                        wait(10);
                        }
                    } else {
                        pc.printf("sonething went wrong with connection. not connected \r\n");
                        goto nustConnection;
                    }
                } else {
                    pc.printf("conenction fail!\r\n");
                    goto nustConnection;
                }
            } else {
                pc.printf("hardware not intialized!\r\n");
                goto hardwareInit;
            }
        }
        wait(1);
    }
}
