/* mbed CustomExplorerRobot Library
 *
 * CustomExplorerRobot.h
 *
 * Copyright (c) 2016 ??????
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef CUSTOMEXPLORERROBOT_H
#define CUSTOMEXPLORERROBOT_H

#include "mbed.h"
#include "BD6212.h"

/** CustomExplorerRobot control class
 *
 * Example:
 * @code
 * // Drive the CustomExplorerRobot forward, turn left, back, turn right, at half speed for half a second
 
#include "mbed.h"
#include "CustomExplorerRobot.h"

CustomExplorerRobot cer;

int main() {
    
    wait(0.5f);
    cer.forward(0.5f);
    wait(0.5f);
    cer.left(0.5f);
    wait(0.5f);
    cer.backward(0.5f);
    wait(0.5f);
    cer.right(0.5f);
    wait(0.5f);
    cer.stop();
    
    return 0;
}
 * @endcode
 */
class CustomExplorerRobot{
    public:
    /** Create the CustomExplorerRobot object connected to the default pins
     */
    CustomExplorerRobot();
    
    /** Directly control the speed and direction of the left motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void left_motor(float speed);
    
    /** Directly control the speed and direction of the right motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void right_motor(float speed);
    
    /** Drive both motors forward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void forward(float speed);
    
    /** Drive both motors backward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void backward(float speed);
    
    /** Drive left motor backwards and right motor forwards at the same speed to turn on the spot
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void left(float speed);
    
    /** Drive left motor forward and right motor backwards at the same speed to turn on the spot
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void right(float speed);
    
    /** Stop both motors
     *
     */
    void stop(void);
    
    protected:
    BD6212 _right;
    BD6212 _left;
    
    DigitalOut _redled;
    DigitalOut _blueled;
    
    PwmOut _buzzer;
    
};

#endif
